/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.io.Closeable;
import java.net.SocketAddress;
import java.nio.channels.GatheringByteChannel;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.xnio.XnioChannel;
import org.jboss.netty.channel.xnio.XnioChannelConfig;
import org.jboss.netty.channel.xnio.XnioChannelRegistry;
import org.jboss.netty.util.internal.LinkedTransferQueue;
import org.jboss.netty.util.internal.ThreadLocalBoolean;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.ConnectedChannel;
import org.jboss.xnio.channels.MultipointWritableMessageChannel;
import org.jboss.xnio.channels.WritableMessageChannel;

class BaseXnioChannel
extends AbstractChannel
implements XnioChannel {
    private final XnioChannelConfig config;
    volatile java.nio.channels.Channel xnioChannel;
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    final Object writeLock = new Object();
    final Queue<MessageEvent> writeBuffer = new WriteBuffer();
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    MessageEvent currentWriteEvent;
    int currentWriteIndex;

    BaseXnioChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, XnioChannelConfig config) {
        super(parent, factory, pipeline, sink);
        this.config = config;
    }

    public XnioChannelConfig getConfig() {
        return this.config;
    }

    public SocketAddress getLocalAddress() {
        SocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            java.nio.channels.Channel xnioChannel = this.xnioChannel;
            if (!this.isOpen() || !(xnioChannel instanceof BoundChannel)) {
                return null;
            }
            this.localAddress = localAddress = (SocketAddress)((BoundChannel)xnioChannel).getLocalAddress();
        }
        return localAddress;
    }

    public SocketAddress getRemoteAddress() {
        SocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            java.nio.channels.Channel xnioChannel = this.xnioChannel;
            if (!this.isOpen() || !(xnioChannel instanceof ConnectedChannel)) {
                return null;
            }
            this.remoteAddress = remoteAddress = (SocketAddress)((ConnectedChannel)xnioChannel).getPeerAddress();
        }
        return remoteAddress;
    }

    public boolean isBound() {
        return this.getLocalAddress() != null;
    }

    public boolean isConnected() {
        return this.getRemoteAddress() != null;
    }

    public int getInterestOps() {
        int highWaterMark;
        int lowWaterMark;
        if (!this.isOpen()) {
            return 4;
        }
        int interestOps = this.getRawInterestOps();
        int writeBufferSize = this.writeBufferSize.get();
        interestOps = writeBufferSize != 0 ? (this.highWaterMarkCounter.get() > 0 ? (writeBufferSize >= (lowWaterMark = this.getConfig().getWriteBufferLowWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB)) : (writeBufferSize >= (highWaterMark = this.getConfig().getWriteBufferHighWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB))) : (interestOps &= 0xFFFFFFFB);
        return interestOps;
    }

    int getRawInterestOps() {
        return super.getInterestOps();
    }

    void setRawInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    public ChannelFuture write(Object message) {
        java.nio.channels.Channel xnioChannel = this.xnioChannel;
        if (xnioChannel instanceof MultipointWritableMessageChannel) {
            SocketAddress remoteAddress = this.getRemoteAddress();
            if (remoteAddress != null) {
                return this.write(message, remoteAddress);
            }
            return this.getUnsupportedOperationFuture();
        }
        if (xnioChannel instanceof GatheringByteChannel || xnioChannel instanceof WritableMessageChannel) {
            return super.write(message);
        }
        return this.getUnsupportedOperationFuture();
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            return this.write(message);
        }
        java.nio.channels.Channel xnioChannel = this.xnioChannel;
        if (xnioChannel instanceof MultipointWritableMessageChannel) {
            return super.write(message);
        }
        return this.getUnsupportedOperationFuture();
    }

    void closeNow(ChannelFuture future) {
        SocketAddress localAddress = this.getLocalAddress();
        SocketAddress remoteAddress = this.getRemoteAddress();
        if (!this.setClosed()) {
            future.setSuccess();
            return;
        }
        try {
            IoUtils.safeClose((Closeable)this.xnioChannel);
            this.xnioChannel = null;
            XnioChannelRegistry.unregisterChannelMapping(this);
            future.setSuccess();
            if (remoteAddress != null) {
                Channels.fireChannelDisconnected(this);
            }
            if (localAddress != null) {
                Channels.fireChannelUnbound(this);
            }
            Channels.fireChannelClosed(this);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(this, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteBuffer
    extends LinkedTransferQueue<MessageEvent> {
        private static final long serialVersionUID = 9223361436545857472L;
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();

        WriteBuffer() {
        }

        @Override
        public boolean offer(MessageEvent e) {
            int highWaterMark;
            boolean success = super.offer(e);
            assert (success);
            int messageSize = ((ChannelBuffer)e.getMessage()).readableBytes();
            int newWriteBufferSize = BaseXnioChannel.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = BaseXnioChannel.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                BaseXnioChannel.this.highWaterMarkCounter.incrementAndGet();
                if (!((Boolean)this.notifying.get()).booleanValue()) {
                    this.notifying.set(Boolean.TRUE);
                    Channels.fireChannelInterestChanged(BaseXnioChannel.this);
                    this.notifying.set(Boolean.FALSE);
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e = (MessageEvent)super.poll();
            if (e != null) {
                int messageSize = ((ChannelBuffer)e.getMessage()).readableBytes();
                int newWriteBufferSize = BaseXnioChannel.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = BaseXnioChannel.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    BaseXnioChannel.this.highWaterMarkCounter.decrementAndGet();
                    if (!((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(BaseXnioChannel.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return e;
        }
    }
}

