/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpMessageDecoder
extends ReplayingDecoder<State> {
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final int maxChunkSize;
    private HttpMessage message;
    private ChannelBuffer content;
    private long chunkSize;
    private int headerSize;

    protected HttpMessageDecoder() {
        this(4096, 8192, 8192);
    }

    protected HttpMessageDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        super(State.SKIP_CONTROL_CHARS, true);
        if (maxInitialLineLength <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be a positive integer: " + maxInitialLineLength);
        }
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxChunkSize);
        }
        if (maxChunkSize < 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderSize = maxHeaderSize;
        this.maxChunkSize = maxChunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case SKIP_CONTROL_CHARS: {
                try {
                    this.skipControlCharacters(buffer);
                    this.checkpoint(State.READ_INITIAL);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.checkpoint();
                    throw throwable;
                }
                this.checkpoint();
                {
                }
            }
            case READ_INITIAL: {
                String[] initialLine = this.splitInitialLine(this.readLine(buffer, this.maxInitialLineLength));
                if (initialLine.length < 3) {
                    this.checkpoint(State.SKIP_CONTROL_CHARS);
                    return null;
                }
                this.message = this.createMessage(initialLine);
                this.checkpoint(State.READ_HEADER);
            }
            case READ_HEADER: {
                State nextState = this.readHeaders(buffer);
                this.checkpoint(nextState);
                if (nextState == State.READ_CHUNK_SIZE) {
                    this.message.setChunked(true);
                    return this.message;
                }
                if (nextState == State.SKIP_CONTROL_CHARS) {
                    this.message.removeHeader("Content-Length");
                    this.message.removeHeader("Transfer-Encoding");
                    return this.message;
                }
                long contentLength = HttpHeaders.getContentLength(this.message, -1L);
                if (contentLength == 0L || contentLength == -1L && this.isDecodingRequest()) {
                    this.content = ChannelBuffers.EMPTY_BUFFER;
                    return this.reset();
                }
                switch (nextState) {
                    case READ_FIXED_LENGTH_CONTENT: {
                        if (contentLength <= (long)this.maxChunkSize) break;
                        this.checkpoint(State.READ_FIXED_LENGTH_CONTENT_AS_CHUNKS);
                        this.message.setChunked(true);
                        this.chunkSize = HttpHeaders.getContentLength(this.message, -1L);
                        return this.message;
                    }
                    case READ_VARIABLE_LENGTH_CONTENT: {
                        if (buffer.readableBytes() <= this.maxChunkSize) break;
                        this.checkpoint(State.READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS);
                        this.message.setChunked(true);
                        return this.message;
                    }
                }
                return null;
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                if (this.content == null) {
                    this.content = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
                }
                this.content.writeBytes(buffer.readBytes(buffer.readableBytes()));
                return this.reset();
            }
            case READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS: {
                int chunkSize = Math.min(this.maxChunkSize, buffer.readableBytes());
                DefaultHttpChunk chunk = new DefaultHttpChunk(buffer.readBytes(chunkSize));
                if (!buffer.readable()) {
                    this.reset();
                    if (!chunk.isLast()) {
                        return new Object[]{chunk, HttpChunk.LAST_CHUNK};
                    }
                }
                return chunk;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                this.readFixedLengthContent(buffer);
                return this.reset();
            }
            case READ_FIXED_LENGTH_CONTENT_AS_CHUNKS: {
                DefaultHttpChunk chunk;
                long chunkSize = this.chunkSize;
                if (chunkSize > (long)this.maxChunkSize) {
                    chunk = new DefaultHttpChunk(buffer.readBytes(this.maxChunkSize));
                    chunkSize -= (long)this.maxChunkSize;
                } else {
                    assert (chunkSize <= Integer.MAX_VALUE);
                    chunk = new DefaultHttpChunk(buffer.readBytes((int)chunkSize));
                    chunkSize = 0L;
                }
                this.chunkSize = chunkSize;
                if (chunkSize == 0L) {
                    this.reset();
                    if (!chunk.isLast()) {
                        return new Object[]{chunk, HttpChunk.LAST_CHUNK};
                    }
                }
                return chunk;
            }
            case READ_CHUNK_SIZE: {
                String line = this.readLine(buffer, this.maxInitialLineLength);
                int chunkSize = this.getChunkSize(line);
                this.chunkSize = chunkSize;
                if (chunkSize == 0) {
                    this.checkpoint(State.READ_CHUNK_FOOTER);
                    return null;
                }
                if (chunkSize > this.maxChunkSize) {
                    this.checkpoint(State.READ_CHUNKED_CONTENT_AS_CHUNKS);
                } else {
                    this.checkpoint(State.READ_CHUNKED_CONTENT);
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                DefaultHttpChunk chunk = new DefaultHttpChunk(buffer.readBytes((int)this.chunkSize));
                this.checkpoint(State.READ_CHUNK_DELIMITER);
                return chunk;
            }
            case READ_CHUNKED_CONTENT_AS_CHUNKS: {
                DefaultHttpChunk chunk;
                long chunkSize = this.chunkSize;
                if (chunkSize > (long)this.maxChunkSize) {
                    chunk = new DefaultHttpChunk(buffer.readBytes(this.maxChunkSize));
                    chunkSize -= (long)this.maxChunkSize;
                } else {
                    assert (chunkSize <= Integer.MAX_VALUE);
                    chunk = new DefaultHttpChunk(buffer.readBytes((int)chunkSize));
                    chunkSize = 0L;
                }
                this.chunkSize = chunkSize;
                if (chunkSize == 0L) {
                    this.checkpoint(State.READ_CHUNK_DELIMITER);
                }
                if (!chunk.isLast()) {
                    return chunk;
                }
            }
            case READ_CHUNK_DELIMITER: {
                while (true) {
                    byte next;
                    if ((next = buffer.readByte()) == 13) {
                        if (buffer.readByte() != 10) continue;
                        this.checkpoint(State.READ_CHUNK_SIZE);
                        return null;
                    }
                    if (next == 10) break;
                }
                this.checkpoint(State.READ_CHUNK_SIZE);
                return null;
            }
            case READ_CHUNK_FOOTER: {
                HttpChunkTrailer trailer = this.readTrailingHeaders(buffer);
                if (this.maxChunkSize == 0) {
                    return this.reset();
                }
                this.reset();
                return trailer;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.getStatus().getCode();
            if (code < 200) {
                return true;
            }
            switch (code) {
                case 204: 
                case 205: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    private Object reset() {
        HttpMessage message = this.message;
        ChannelBuffer content = this.content;
        if (content != null) {
            message.setContent(content);
            this.content = null;
        }
        this.message = null;
        this.checkpoint(State.SKIP_CONTROL_CHARS);
        return message;
    }

    private void skipControlCharacters(ChannelBuffer buffer) {
        char c;
        while (Character.isISOControl(c = (char)buffer.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
    }

    private void readFixedLengthContent(ChannelBuffer buffer) {
        long length = HttpHeaders.getContentLength(this.message, -1L);
        assert (length <= Integer.MAX_VALUE);
        if (this.content == null) {
            this.content = buffer.readBytes((int)length);
        } else {
            this.content.writeBytes(buffer.readBytes((int)length));
        }
    }

    private State readHeaders(ChannelBuffer buffer) throws TooLongFrameException {
        this.headerSize = 0;
        HttpMessage message = this.message;
        String line = this.readHeader(buffer);
        String lastHeader = null;
        if (line.length() != 0) {
            message.clearHeaders();
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    List<String> current = message.getHeaders(lastHeader);
                    int lastPos = current.size() - 1;
                    String newString = current.get(lastPos) + line.trim();
                    current.set(lastPos, newString);
                    continue;
                }
                String[] header = this.splitHeader(line);
                message.addHeader(header[0], header[1]);
                lastHeader = header[0];
            } while ((line = this.readHeader(buffer)).length() != 0);
        }
        State nextState = this.isContentAlwaysEmpty(message) ? State.SKIP_CONTROL_CHARS : (message.isChunked() ? State.READ_CHUNK_SIZE : (HttpHeaders.getContentLength(message, -1L) >= 0L ? State.READ_FIXED_LENGTH_CONTENT : State.READ_VARIABLE_LENGTH_CONTENT));
        return nextState;
    }

    private HttpChunkTrailer readTrailingHeaders(ChannelBuffer buffer) throws TooLongFrameException {
        this.headerSize = 0;
        String line = this.readHeader(buffer);
        String lastHeader = null;
        if (line.length() != 0) {
            DefaultHttpChunkTrailer trailer = new DefaultHttpChunkTrailer();
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    List<String> current = trailer.getHeaders(lastHeader);
                    if (current.size() == 0) continue;
                    int lastPos = current.size() - 1;
                    String newString = current.get(lastPos) + line.trim();
                    current.set(lastPos, newString);
                    continue;
                }
                String[] header = this.splitHeader(line);
                String name = header[0];
                if (!(name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer"))) {
                    trailer.addHeader(name, header[1]);
                }
                lastHeader = name;
            } while ((line = this.readHeader(buffer)).length() != 0);
            return trailer;
        }
        return HttpChunk.LAST_CHUNK;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readHeader(ChannelBuffer buffer) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        int headerSize = this.headerSize;
        block4: while (true) {
            char nextByte = (char)buffer.readByte();
            ++headerSize;
            switch (nextByte) {
                case '\r': {
                    nextByte = (char)buffer.readByte();
                    ++headerSize;
                    if (nextByte != '\n') break;
                    break block4;
                }
                case '\n': {
                    break block4;
                }
            }
            if (headerSize >= this.maxHeaderSize) {
                throw new TooLongFrameException("HTTP header is larger than " + this.maxHeaderSize + " bytes.");
            }
            sb.append(nextByte);
        }
        this.headerSize = headerSize;
        return sb.toString();
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    private int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    private String readLine(ChannelBuffer buffer, int maxLineLength) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                nextByte = buffer.readByte();
                if (nextByte != 10) continue;
                return sb.toString();
            }
            if (nextByte == 10) {
                return sb.toString();
            }
            if (lineLength >= maxLineLength) {
                throw new TooLongFrameException("An HTTP line is larger than " + maxLineLength + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
    }

    private String[] splitInitialLine(String sb) {
        int aStart = this.findNonWhitespace(sb, 0);
        int aEnd = this.findWhitespace(sb, aStart);
        int bStart = this.findNonWhitespace(sb, aEnd);
        int bEnd = this.findWhitespace(sb, bStart);
        int cStart = this.findNonWhitespace(sb, bEnd);
        int cEnd = this.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), sb.substring(cStart, cEnd)};
    }

    private String[] splitHeader(String sb) {
        int valueStart;
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = this.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        if ((valueStart = this.findNonWhitespace(sb, colonEnd)) == length) {
            return new String[]{sb.substring(nameStart, nameEnd), ""};
        }
        int valueEnd = this.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.substring(valueStart, valueEnd)};
    }

    private int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS,
        READ_FIXED_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT_AS_CHUNKS,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNKED_CONTENT_AS_CHUNKS,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER;

    }
}

