/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.deployers.vfs.spi.structure.modified.SynchVisitor;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddVisitor
extends SynchVisitor {
    private VirtualFile originalRoot;
    private VirtualFile tempRoot;

    public AddVisitor(VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile originalRoot, VirtualFile tempRoot) {
        this(null, attributes, cache, synchAdapter, originalRoot, tempRoot);
    }

    public AddVisitor(VirtualFileFilter filter, VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile originalRoot, VirtualFile tempRoot) {
        super(filter, attributes, cache, synchAdapter);
        if (tempRoot == null) {
            throw new IllegalArgumentException("Null temp root");
        }
        this.originalRoot = originalRoot;
        this.tempRoot = tempRoot;
    }

    @Override
    public void doVisit(VirtualFile file) throws Exception {
        String path = file.getPathNameRelativeTo(this.originalRoot);
        VirtualFile child = this.tempRoot.getChild(path);
        if (!child.exists()) {
            long timestamp = this.getSynchAdapter().add(file, this.tempRoot, path);
            this.getCache().putCacheValue(file, timestamp);
        }
    }
}

