/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs;

import java.io.IOException;
import java.net.URL;
import org.jboss.osgi.vfs.VFSAdaptor;
import org.jboss.osgi.vfs.VirtualFile;

public abstract class AbstractVFS {
    private static VFSAdaptor adaptor;

    public static VirtualFile getRoot(URL url) throws IOException {
        return AbstractVFS.getVFSAdaptor().getRoot(url);
    }

    public static VirtualFile adapt(Object virtualFile) {
        return AbstractVFS.getVFSAdaptor().adapt(virtualFile);
    }

    public static Object adapt(VirtualFile virtualFile) {
        return AbstractVFS.getVFSAdaptor().adapt(virtualFile);
    }

    private static VFSAdaptor getVFSAdaptor() {
        if (adaptor == null) {
            String adaptorName;
            Class<?> adaptorClass = null;
            try {
                adaptorName = "org.jboss.osgi.vfs21.VFSAdaptor21";
                adaptorClass = AbstractVFS.class.getClassLoader().loadClass(adaptorName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (adaptorClass == null) {
                try {
                    adaptorName = "org.jboss.osgi.vfs30.VFSAdaptor30";
                    adaptorClass = AbstractVFS.class.getClassLoader().loadClass(adaptorName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (adaptorClass == null) {
                throw new IllegalStateException("Cannot load VFS adaptor");
            }
            try {
                adaptor = (VFSAdaptor)adaptorClass.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot instanciate VFS adaptor");
            }
        }
        return adaptor;
    }
}

