/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.template;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngine
implements Serializable {
    private static final long serialVersionUID = -6490715202402123042L;
    private final Map<String, String> tokens;
    static String tokenRegex = "<%\\s*(\\w+\\.?)+\\s*%>";
    static String keyRegex = "(\\w+\\.?)+";
    static Pattern tokenPattern = Pattern.compile(tokenRegex);
    static Pattern keyPattern = Pattern.compile(keyRegex);

    public TemplateEngine(Map<String, String> tokens) {
        this.tokens = tokens;
    }

    public String replaceTokens(String input) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = tokenPattern.matcher(input);
        while (matcher.find()) {
            String key;
            String value;
            String next = matcher.group();
            Matcher keyMatcher = keyPattern.matcher(next);
            if (keyMatcher.find() && (value = this.tokens.get(key = keyMatcher.group())) != null) {
                next = value;
            }
            matcher.appendReplacement(buffer, next);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

