/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.util.file.ContentFileInfo;
import org.rhq.core.util.file.GenericContentFileInfo;
import org.rhq.core.util.file.JarContentFileInfo;

public class ContentFileInfoFactory {
    private static final List<Class<? extends ContentFileInfo>> contentFileInfoTypes = new ArrayList<Class<? extends ContentFileInfo>>();

    public static ContentFileInfo createContentFileInfo(File file) {
        ContentFileInfo fileInfo;
        for (Class<? extends ContentFileInfo> clazz : contentFileInfoTypes) {
            try {
                fileInfo = clazz.getConstructor(File.class).newInstance(file);
                if (!fileInfo.isValid()) continue;
                return fileInfo;
            }
            catch (Exception ignore) {
            }
        }
        fileInfo = new GenericContentFileInfo(file);
        if (!fileInfo.isValid()) {
            throw new IllegalArgumentException("Cannot get info from file [" + file + "]. Does it exist?");
        }
        return fileInfo;
    }

    static {
        contentFileInfoTypes.add(JarContentFileInfo.class);
    }
}

