/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployer;

import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitFilter;
import org.jboss.osgi.deployer.helpers.BundleDeploymentUnitFilter;
import org.jboss.osgi.deployer.helpers.PackageAdminDependencyItem;
import org.jboss.osgi.spi.util.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoaderDeployer
extends AbstractSimpleRealDeployer<Bundle> {
    private DeploymentUnitFilter filter = new BundleDeploymentUnitFilter();
    private BundleContext systemContext;

    public BundleClassLoaderDeployer() {
        super(Bundle.class);
        this.addOutput(ClassLoaderFactory.class);
        this.setStage(DeploymentStages.POST_PARSE);
    }

    public void setSystemContext(BundleContext systemContext) {
        this.systemContext = systemContext;
    }

    public void deploy(DeploymentUnit unit, Bundle bundle) throws DeploymentException {
        ClassLoaderFactory factory = this.createClassLoaderFactory(bundle);
        unit.addAttachment(ClassLoaderFactory.class, (Object)factory);
        String propStart = this.systemContext.getProperty("org.jboss.osgi.deferred.start");
        if (!Boolean.parseBoolean(propStart != null ? propStart : "true")) {
            unit.addIDependOn((DependencyItem)new PackageAdminDependencyItem(this.systemContext, bundle));
        }
        if (this.filter != null) {
            unit.addAttachment(DeploymentUnitFilter.class, (Object)this.filter);
        }
    }

    protected ClassLoaderFactory createClassLoaderFactory(final Bundle bundle) {
        return new ClassLoaderFactory(){

            public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
                return BundleClassLoader.createClassLoader((Bundle)bundle);
            }

            public void removeClassLoader(DeploymentUnit unit) throws Exception {
            }
        };
    }

    public void setFilter(DeploymentUnitFilter filter) {
        this.filter = filter;
    }
}

