/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployer;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStartLevelDeployer
extends AbstractSimpleRealDeployer<Bundle> {
    private BundleContext systemContext;
    private ServiceTracker startLevelTracker;

    public BundleStartLevelDeployer() {
        super(Bundle.class);
    }

    public void setSystemContext(BundleContext systemContext) {
        this.systemContext = systemContext;
    }

    public void deploy(DeploymentUnit unit, Bundle bundle) throws DeploymentException {
        Deployment dep = (Deployment)unit.getAttachment(Deployment.class);
        Integer propStart = dep != null ? dep.getStartLevel() : null;
        StartLevel startLevel = this.getStartLevel();
        if (propStart != null && startLevel != null) {
            startLevel.setBundleStartLevel(bundle, propStart.intValue());
        }
    }

    private StartLevel getStartLevel() {
        if (this.startLevelTracker == null) {
            this.startLevelTracker = new ServiceTracker(this.systemContext, StartLevel.class.getName(), null);
            this.startLevelTracker.open();
        }
        return (StartLevel)this.startLevelTracker.getService();
    }
}

