/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.internal.HttpServiceStopped;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class HttpServiceProxy
implements StoppableHttpService {
    private static final Log LOG = LogFactory.getLog(HttpServiceProxy.class);
    private StoppableHttpService m_delegate;

    public HttpServiceProxy(StoppableHttpService delegate) {
        NullArgumentException.validateNotNull(delegate, "Delegate");
        this.m_delegate = delegate;
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        LOG.debug("Registering servlet: [" + alias + "] -> " + servlet);
        this.m_delegate.registerServlet(alias, servlet, initParams, httpContext);
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        LOG.debug("Registering resource: [" + alias + "] -> " + name);
        this.m_delegate.registerResources(alias, name, httpContext);
    }

    public void unregister(String alias) {
        LOG.debug("Unregistering [" + alias + "]");
        this.m_delegate.unregister(alias);
    }

    public HttpContext createDefaultHttpContext() {
        LOG.debug("Creating adefault context");
        return this.m_delegate.createDefaultHttpContext();
    }

    public synchronized void stop() {
        LOG.debug("Stopping http service: [" + this + "]");
        StoppableHttpService stopping = this.m_delegate;
        this.m_delegate = new HttpServiceStopped();
        stopping.stop();
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet [" + servlet + "]");
        this.m_delegate.registerServlet(servlet, urlPatterns, initParams, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet [" + servlet + "] with name [" + servletName + "]");
        this.m_delegate.registerServlet(servlet, servletName, urlPatterns, initParams, httpContext);
    }

    public void unregisterServlet(Servlet servlet) {
        LOG.debug("Unregistering servlet [" + servlet + "]");
        this.m_delegate.unregisterServlet(servlet);
    }

    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        LOG.debug("Registering event listener [" + listener + "]");
        this.m_delegate.registerEventListener(listener, httpContext);
    }

    public void unregisterEventListener(EventListener listener) {
        LOG.debug("Unregistering event listener [" + listener + "]");
        this.m_delegate.unregisterEventListener(listener);
    }

    public void registerFilter(Filter filter, String[] urlPatterns, String[] aliases, Dictionary initParams, HttpContext httpContext) {
        LOG.debug("Registering filter [" + filter + "]");
        this.m_delegate.registerFilter(filter, urlPatterns, aliases, initParams, httpContext);
    }

    public void unregisterFilter(Filter filter) {
        LOG.debug("Unregistering filter [" + filter + "]");
        this.m_delegate.unregisterFilter(filter);
    }

    public void setContextParam(Dictionary params, HttpContext httpContext) {
        LOG.debug("Setting context paramters [" + params + "] for http context [" + httpContext + "]");
        this.m_delegate.setContextParam(params, httpContext);
    }

    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        LOG.debug("Setting session timeout to " + minutes + " minutes for http context [" + httpContext + "]");
        this.m_delegate.setSessionTimeout(minutes, httpContext);
    }

    public void registerJsps(String[] urlPatterns, HttpContext httpContext) {
        LOG.debug("Registering jsps");
        this.m_delegate.registerJsps(urlPatterns, httpContext);
    }

    public void unregisterJsps(HttpContext httpContext) {
        LOG.debug("Unregistering jsps");
        this.m_delegate.unregisterJsps(httpContext);
    }

    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        LOG.debug("Registering error page [" + error + "]");
        this.m_delegate.registerErrorPage(error, location, httpContext);
    }

    public void unregisterErrorPage(String error, HttpContext httpContext) {
        LOG.debug("Unregistering error page [" + error + "]");
        this.m_delegate.unregisterErrorPage(error, httpContext);
    }

    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        LOG.debug("Registering welcome files [" + Arrays.toString(welcomeFiles) + "]");
        this.m_delegate.registerWelcomeFiles(welcomeFiles, redirect, httpContext);
    }

    public void unregisterWelcomeFiles(HttpContext httpContext) {
        LOG.debug("Unregistering welcome files");
        this.m_delegate.unregisterWelcomeFiles(httpContext);
    }

    public SharedWebContainerContext getDefaultSharedHttpContext() {
        return this.m_delegate.getDefaultSharedHttpContext();
    }
}

