/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.spi.filter.RecursivePackageClassFilter;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.classloading.OSGiClassLoaderPolicy;
import org.jboss.osgi.framework.classloading.OSGiCoreClassFilter;
import org.jboss.osgi.framework.plugins.SystemPackagesPlugin;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiClassLoaderDomain
extends ClassLoaderDomain {
    private ClassLoaderSystem classLoaderSystem;
    private OSGiBundleManager bundleManager;
    private List<URL> classPath = new ArrayList<URL>();

    public OSGiClassLoaderDomain(String domainName) {
        super(domainName);
    }

    public void setClassLoaderSystem(ClassLoaderSystem classLoaderSystem) {
        this.classLoaderSystem = classLoaderSystem;
    }

    public void setBundleManager(OSGiBundleManager bundleManager) {
        this.bundleManager = bundleManager;
    }

    public void setClassPath(List<URL> classPath) {
        this.classPath = classPath;
    }

    protected Class<?> loadClass(BaseClassLoader classLoader, String name, boolean allExports) throws ClassNotFoundException {
        return super.loadClass(classLoader, name, allExports);
    }

    public void start() throws IOException {
        if (this.classLoaderSystem == null) {
            throw new IllegalArgumentException("Null classLoaderSystem");
        }
        if (this.bundleManager == null) {
            throw new IllegalArgumentException("Null bundleManager");
        }
        if (this.classPath == null) {
            throw new IllegalArgumentException("Null classPath");
        }
        this.classLoaderSystem.registerDomain((ClassLoaderDomain)this);
        PackageClassFilter systemFilter = PackageClassFilter.createPackageClassFilterFromString((String)this.getSystemPackagesAsString());
        RecursivePackageClassFilter javaFilter = RecursivePackageClassFilter.createRecursivePackageClassFilter((String[])new String[]{"java"});
        CombiningClassFilter filter = CombiningClassFilter.create((ClassFilter[])new ClassFilter[]{javaFilter, OSGiCoreClassFilter.INSTANCE, systemFilter});
        this.setParentPolicy(new ParentPolicy((ClassFilter)filter, ClassFilterUtils.NOTHING));
        VirtualFile[] roots = new VirtualFile[this.classPath.size()];
        for (int i = 0; i < this.classPath.size(); ++i) {
            URL url = this.classPath.get(i);
            try {
                roots[i] = VFS.getChild((URL)url);
                continue;
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException("Invalid classpath: " + url);
            }
        }
        OSGiSystemState systemBundle = this.bundleManager.getSystemBundle();
        OSGiClassLoaderPolicy systemPolicy = new OSGiClassLoaderPolicy((AbstractBundleState)systemBundle, roots);
        this.classLoaderSystem.registerClassLoaderPolicy(this.getName(), (ClassLoaderPolicy)systemPolicy);
    }

    private String getSystemPackagesAsString() {
        SystemPackagesPlugin syspackPlugin = (SystemPackagesPlugin)this.bundleManager.getPlugin(SystemPackagesPlugin.class);
        List sysPackages = syspackPlugin.getSystemPackages(false);
        StringBuffer sysPackageString = new StringBuffer();
        for (String name : sysPackages) {
            sysPackageString.append(name + ",");
        }
        return sysPackageString.toString();
    }
}

