/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.List;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.classloader.VFSDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.classloading.OSGiClassLoaderPolicy;
import org.jboss.vfs.VirtualFile;

public class OSGiClassLoaderFactory
implements ClassLoaderFactory {
    private ClassLoaderSystem system;

    public void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }

    public ClassLoader createClassLoader(final DeploymentUnit unit) throws Exception {
        if (!(unit instanceof VFSDeploymentUnit)) {
            throw new IllegalStateException("Not an instance of VFSDeploymentUnit: " + unit);
        }
        Module module = (Module)unit.getAttachment(Module.class);
        if (!(module instanceof VFSDeploymentClassLoaderPolicyModule)) {
            throw new IllegalStateException("Not an instance of VFSDeploymentClassLoaderPolicyModule: " + module);
        }
        VFSDeploymentClassLoaderPolicyModule vfsModule = (VFSDeploymentClassLoaderPolicyModule)module;
        vfsModule.setPolicyFactory(new ClassLoaderPolicyFactory(){

            public ClassLoaderPolicy createClassLoaderPolicy() {
                VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
                AbstractBundleState bundleState = (AbstractBundleState)unit.getAttachment(AbstractBundleState.class);
                VirtualFile[] roots = this.getClassLoaderPolicyRoots(bundleState, vfsUnit);
                OSGiClassLoaderPolicy policy = new OSGiClassLoaderPolicy(bundleState, roots);
                unit.addAttachment(ClassLoaderPolicy.class, (Object)policy);
                return policy;
            }

            private VirtualFile[] getClassLoaderPolicyRoots(AbstractBundleState bundleState, VFSDeploymentUnit vfsUnit) {
                List classPaths = vfsUnit.getClassPath();
                VirtualFile[] policyRoots = new VirtualFile[classPaths.size()];
                classPaths.toArray(policyRoots);
                return policyRoots;
            }
        });
        return vfsModule.registerClassLoaderPolicy(this.system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(DeploymentUnit unit) throws Exception {
        Module module = (Module)unit.getAttachment(Module.class);
        if (module == null) {
            return;
        }
        ClassLoader classLoader = unit.getClassLoader();
        try {
            this.system.unregisterClassLoader(classLoader);
        }
        finally {
            module.reset();
        }
    }
}

