/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.util.jar.Manifest;
import org.jboss.deployers.vfs.spi.deployer.ManifestDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.internal.AbstractOSGiMetaData;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiManifestParsingDeployer
extends ManifestDeployer<OSGiMetaData> {
    public OSGiManifestParsingDeployer() {
        super(OSGiMetaData.class);
        this.setTopLevelOnly(true);
    }

    protected OSGiMetaData createMetaData(Manifest manifest) throws Exception {
        int manifestVersion = BundleInfo.getBundleManifestVersion((Manifest)manifest);
        if (manifestVersion < 0 || manifestVersion > 2) {
            return null;
        }
        AbstractOSGiMetaData osgiMetaData = new AbstractOSGiMetaData(manifest);
        return osgiMetaData;
    }

    protected void init(VFSDeploymentUnit unit, OSGiMetaData osgiMetaData, VirtualFile file) throws Exception {
        super.init(unit, (Object)osgiMetaData, file);
        String symbolicName = osgiMetaData.getBundleSymbolicName();
        if (symbolicName != null) {
            this.log.debug((Object)("Bundle-SymbolicName: " + symbolicName));
            unit.addAttachment("org.jboss.osgi.bundle.symbolic.name", (Object)symbolicName);
        }
    }
}

