/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Collections;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.structure.spi.DeploymentRegistry;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiServiceState;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.internal.AbstractOSGiMetaData;
import org.jboss.osgi.framework.plugins.ControllerContextPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerContextPluginImpl
extends AbstractPlugin
implements ControllerContextPlugin {
    final Logger log = Logger.getLogger(ControllerContextPluginImpl.class);
    private DeploymentRegistry registry;

    public ControllerContextPluginImpl(OSGiBundleManager bundleManager, DeploymentRegistry registry) {
        super(bundleManager);
        if (registry == null) {
            throw new IllegalArgumentException("Null deployment registry");
        }
        this.registry = registry;
    }

    public DeploymentUnit putContext(ControllerContext context, DeploymentUnit unit) {
        return this.registry.putContext(context, unit);
    }

    public DeploymentUnit removeContext(ControllerContext context, DeploymentUnit unit) {
        return this.registry.removeContext(context, unit);
    }

    public Set<ControllerContext> getRegisteredContexts(AbstractBundleState bundleState) {
        if (!(bundleState instanceof OSGiBundleState)) {
            return Collections.emptySet();
        }
        DeploymentUnit unit = ((OSGiBundleState)bundleState).getDeploymentUnit();
        return this.registry.getContexts(unit);
    }

    @Override
    public AbstractBundleState getBundleForUser(Object user) {
        if (user instanceof AbstractBundleState) {
            return (AbstractBundleState)((Object)user);
        }
        if (user instanceof ControllerContext) {
            return this.getBundleForContext((ControllerContext)user);
        }
        throw new IllegalArgumentException("Unknown tracker type: " + user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractBundleState getBundleForContext(ControllerContext context) {
        if (context instanceof OSGiServiceState) {
            OSGiServiceState service = (OSGiServiceState)context;
            return service.getBundleState();
        }
        OSGiBundleManager bundleManager = this.getBundleManager();
        DeploymentUnit unit = this.registry.getDeployment(context);
        if (unit != null) {
            DeploymentUnit deploymentUnit = unit;
            synchronized (deploymentUnit) {
                OSGiBundleState bundleState = (OSGiBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
                if (bundleState == null) {
                    OSGiMetaData osgiMetaData = (OSGiMetaData)unit.getAttachment(OSGiMetaData.class);
                    if (osgiMetaData == null) {
                        Manifest manifest = (Manifest)unit.getAttachment(Manifest.class);
                        if (manifest == null) {
                            manifest = new Manifest();
                        }
                        Attributes attributes = manifest.getMainAttributes();
                        attributes.put(new Attributes.Name("Bundle-SymbolicName"), unit.getName());
                        osgiMetaData = new AbstractOSGiMetaData(manifest);
                        unit.addAttachment(OSGiMetaData.class, (Object)osgiMetaData);
                    }
                    try {
                        bundleState = (OSGiBundleState)bundleManager.addDeployment(unit);
                        bundleManager.addBundle(bundleState);
                        bundleState.startInternal();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Cannot dynamically add generic bundle: " + unit, t);
                    }
                }
                return bundleState;
            }
        }
        return bundleManager.getSystemBundle();
    }

    public void unregisterContexts(AbstractBundleState bundleState) {
        if (bundleState instanceof OSGiBundleState) {
            DeploymentUnit unit = ((OSGiBundleState)bundleState).getDeploymentUnit();
            Set contexts = this.registry.getContexts(unit);
            for (ControllerContext context : contexts) {
                if (!(context instanceof ServiceRegistration)) continue;
                ServiceRegistration service = (ServiceRegistration)context;
                service.unregister();
            }
        }
    }
}

