/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.HashSet;
import java.util.List;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleValidator;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.PackageAttribute;

public class OSGiBundleValidatorR4
implements OSGiBundleValidator {
    private OSGiBundleManager bundleManager;

    public OSGiBundleValidatorR4(OSGiBundleManager bundleManager) {
        this.bundleManager = bundleManager;
    }

    public void validateBundle(AbstractBundleState bundleState) {
        List exportPackages;
        String packageName;
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        String symbolicName = bundleState.getSymbolicName();
        if (symbolicName == null) {
            throw new IllegalStateException("Missing Bundle-SymbolicName in: " + (Object)((Object)bundleState));
        }
        int manifestVersion = osgiMetaData.getBundleManifestVersion();
        if (manifestVersion > 2) {
            throw new IllegalStateException("Unsupported manifest version " + manifestVersion + " for " + (Object)((Object)bundleState));
        }
        List importPackages = osgiMetaData.getImportPackages();
        if (importPackages != null && !importPackages.isEmpty()) {
            HashSet<String> packages = new HashSet<String>();
            for (PackageAttribute packageAttribute : importPackages) {
                packageName = packageAttribute.getAttribute();
                if (packages.contains(packageName)) {
                    throw new IllegalStateException("Duplicate import of package " + packageName + " for " + (Object)((Object)bundleState));
                }
                packages.add(packageName);
                if (packageName.startsWith("java.")) {
                    throw new IllegalStateException("Not allowed to import java.* for " + (Object)((Object)bundleState));
                }
                String version = (String)packageAttribute.getAttributeValue("version", String.class);
                String specificationVersion = (String)packageAttribute.getAttributeValue("specification-version", String.class);
                if (version == null || specificationVersion == null || version.equals(specificationVersion)) continue;
                throw new IllegalStateException(packageName + " version and specification version should be the same for " + (Object)((Object)bundleState));
            }
        }
        if ((exportPackages = osgiMetaData.getExportPackages()) != null && !exportPackages.isEmpty()) {
            for (PackageAttribute packageAttribute : exportPackages) {
                packageName = packageAttribute.getAttribute();
                if (!packageName.startsWith("java.")) continue;
                throw new IllegalStateException("Not allowed to export java.* for " + (Object)((Object)bundleState));
            }
        }
        for (AbstractBundleState bundle : this.bundleManager.getBundles()) {
            OSGiMetaData other = bundle.getOSGiMetaData();
            if (!symbolicName.equals(other.getBundleSymbolicName())) continue;
            if (other.isSingleton() && osgiMetaData.isSingleton()) {
                throw new IllegalStateException("Cannot install singleton " + (Object)((Object)bundleState) + " another singleton is already installed: " + bundle.getLocation());
            }
            if (!other.getBundleVersion().equals(osgiMetaData.getBundleVersion())) continue;
            throw new IllegalStateException("Cannot install " + (Object)((Object)bundleState) + " a bundle with that name and version is already installed: " + bundle.getLocation());
        }
    }
}

