/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.AbstractDeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.jboss.osgi.framework.resolver.Resolver;
import org.osgi.framework.Version;

public class OSGiPackageCapability
extends PackageCapability {
    private static final long serialVersionUID = 3940667616588052822L;
    private AbstractBundleState bundleState;
    private PackageAttribute exportPackage;
    private String[] mandatoryAttributes;
    private String shortString;

    public static OSGiPackageCapability create(AbstractBundleState bundleState, PackageAttribute exportPackage) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        String name = exportPackage.getAttribute();
        String versionString = (String)exportPackage.getAttributeValue("version", String.class);
        String oldVersionString = (String)exportPackage.getAttributeValue("specification-version", String.class);
        if (oldVersionString != null) {
            if (versionString != null && !versionString.equals(oldVersionString)) {
                throw new IllegalStateException("version of " + versionString + " does not match " + "specification-version" + " of " + oldVersionString);
            }
            if (versionString == null) {
                versionString = oldVersionString;
            }
        }
        Version version = null;
        if (versionString != null) {
            if (versionString.startsWith("\"") && versionString.endsWith("\"")) {
                versionString = versionString.substring(1, versionString.length() - 1);
            }
            version = Version.parseVersion((String)versionString);
        }
        OSGiPackageCapability capability = new OSGiPackageCapability(bundleState, name, version, exportPackage);
        capability.setSplitPackagePolicy(PackageCapability.SplitPackagePolicy.First);
        return capability;
    }

    private OSGiPackageCapability(AbstractBundleState bundleState, String name, Version version, PackageAttribute exportPackage) {
        super(name, (Object)version);
        this.bundleState = bundleState;
        this.exportPackage = exportPackage;
        String mandatory = (String)exportPackage.getDirectiveValue("mandatory", String.class);
        if (mandatory != null) {
            StringTokenizer tokens = new StringTokenizer(mandatory, ",");
            this.mandatoryAttributes = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                this.mandatoryAttributes[i++] = tokens.nextToken();
            }
        }
        if (exportPackage.getAttribute("bundle-symbolic-name") != null) {
            throw new IllegalStateException("You cannot specify bundle-symbolic-name on an Export-Package");
        }
        if (exportPackage.getAttribute("bundle-version") != null) {
            throw new IllegalStateException("You cannot specify bundle-version on an Export-Package");
        }
    }

    public boolean resolves(Module reqModule, Requirement requirement) {
        if (!super.resolves(reqModule, requirement)) {
            return false;
        }
        if (!(requirement instanceof OSGiPackageRequirement)) {
            return true;
        }
        OSGiPackageRequirement osgiPackageRequirement = (OSGiPackageRequirement)requirement;
        if (!this.matchPackageAttributes(osgiPackageRequirement)) {
            return false;
        }
        OSGiBundleManager bundleManager = this.bundleState.getBundleManager();
        Resolver bundleResolver = bundleManager.getOptionalPlugin(ResolverPlugin.class);
        if (bundleResolver != null) {
            String reqLocation = reqModule.getContextName();
            AbstractBundleState reqBundle = bundleManager.getBundleByLocation(reqLocation);
            if (reqBundle == null) {
                throw new IllegalStateException("Cannot get bundle for: " + reqLocation);
            }
            if (reqBundle instanceof OSGiBundleState) {
                String packageName = osgiPackageRequirement.getName();
                return bundleResolver.match(reqBundle, this.bundleState, packageName);
            }
        }
        return true;
    }

    public Module getModule() {
        AbstractDeployedBundleState depBundle;
        DeploymentUnit unit;
        Module module = null;
        if (this.bundleState instanceof AbstractDeployedBundleState && (module = (Module)(unit = (depBundle = (AbstractDeployedBundleState)this.bundleState).getDeploymentUnit()).getAttachment(Module.class)) == null) {
            throw new IllegalStateException("Cannot obtain module from: " + (Object)((Object)this.bundleState));
        }
        return module;
    }

    public boolean matchPackageAttributes(OSGiPackageRequirement packageRequirement) {
        Map params;
        Object capVersion;
        String reqPackageName;
        String capPackageName = this.getName();
        if (!capPackageName.equals(reqPackageName = packageRequirement.getName())) {
            return false;
        }
        VersionRange reqVersionRange = packageRequirement.getVersionRange();
        if (!reqVersionRange.isInRange(capVersion = this.getVersion())) {
            return false;
        }
        OSGiMetaData osgiMetaData = this.bundleState.getOSGiMetaData();
        PackageAttribute capParameters = this.exportPackage;
        PackageAttribute reqParameters = packageRequirement.getPackageMetaData();
        boolean validMatch = true;
        if (validMatch && this.mandatoryAttributes != null) {
            for (String mand : this.mandatoryAttributes) {
                Parameter reqAttributeValue = reqParameters.getAttribute(mand);
                if (reqParameters != null && reqAttributeValue != null) continue;
                validMatch = false;
                break;
            }
        }
        if (validMatch && reqParameters != null && (params = reqParameters.getAttributes()) != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                String otherValue = (String)reqParameters.getAttributeValue(name, String.class);
                String ourValue = (String)capParameters.getAttributeValue(name, String.class);
                if ("bundle-symbolic-name".equals(name)) {
                    if (!otherValue.equals(osgiMetaData.getBundleSymbolicName())) {
                        validMatch = false;
                    }
                } else if ("bundle-version".equals(name)) {
                    AbstractVersionRange range = AbstractVersionRange.valueOf((String)otherValue);
                    if (!range.isInRange((Object)osgiMetaData.getBundleVersion())) {
                        validMatch = false;
                    }
                } else {
                    if ("specification-version".equals(name) || "version".equals(name)) continue;
                    if (ourValue == null || !ourValue.equals(otherValue)) {
                        validMatch = false;
                    }
                }
                if (validMatch) continue;
                break;
            }
        }
        return validMatch;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiPackageCapability)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toShortString() {
        if (this.shortString == null) {
            StringBuffer buffer = new StringBuffer(this.bundleState.getCanonicalName() + "[" + this.getName());
            Map attributes = this.exportPackage.getAttributes();
            Map directives = this.exportPackage.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + ":=" + ((Parameter)entry.getValue()).getValue());
            }
            for (Map.Entry entry : attributes.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + "=" + ((Parameter)entry.getValue()).getValue());
            }
            buffer.append("]");
            this.shortString = buffer.toString();
        }
        return this.shortString;
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.toShortString());
    }
}

