/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;
import org.jboss.osgi.framework.resolver.ExportPackage;
import org.jboss.osgi.framework.resolver.ResolverBundle;
import org.jboss.osgi.framework.resolver.internal.ResolverBundleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolver
extends AbstractPlugin
implements ResolverPlugin {
    private Map<OSGiBundleState, ResolverBundle> resolverBundleMap = new ConcurrentHashMap<OSGiBundleState, ResolverBundle>();

    public AbstractResolver(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public List<ResolverBundle> getBundles() {
        ArrayList<ResolverBundle> values = new ArrayList<ResolverBundle>(this.resolverBundleMap.values());
        return Collections.unmodifiableList(values);
    }

    @Override
    public ResolverBundle getBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(bundle);
        return this.resolverBundleMap.get((Object)bundleState);
    }

    @Override
    public ResolverBundle getBundle(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolicName");
        }
        if (version == null) {
            version = Version.emptyVersion;
        }
        ResolverBundle retBundle = null;
        for (ResolverBundle aux : this.resolverBundleMap.values()) {
            if (!aux.getSymbolicName().equals(symbolicName) || !aux.getVersion().equals((Object)version)) continue;
            retBundle = aux;
            break;
        }
        return retBundle;
    }

    @Override
    public ResolverBundle addBundle(Bundle bundle) {
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(bundle);
        ResolverBundleImpl resBundle = new ResolverBundleImpl(bundle);
        this.resolverBundleMap.put(bundleState, resBundle);
        return resBundle;
    }

    @Override
    public ResolverBundle removeBundle(Bundle bundle) {
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(bundle);
        return this.resolverBundleMap.remove((Object)bundleState);
    }

    @Override
    public boolean match(Bundle importer, Bundle exporter, String packageName) {
        if (importer == null) {
            throw new IllegalArgumentException("Null importer");
        }
        if (exporter == null) {
            throw new IllegalArgumentException("Null exporter");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Null packageName");
        }
        ExportPackage exportPackage = this.getExporter(importer, packageName);
        if (exportPackage == null) {
            return false;
        }
        Bundle packageOwner = exportPackage.getOwner().getBundle();
        boolean match = packageOwner.getSymbolicName().equals(exporter.getSymbolicName());
        match = match && packageOwner.getVersion().equals((Object)exporter.getVersion());
        return match;
    }
}

