/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.resolver.ExportPackage;
import org.jboss.osgi.framework.resolver.ImportPackage;
import org.jboss.osgi.framework.resolver.RequiredBundle;
import org.jboss.osgi.framework.resolver.ResolverBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolverBundle
implements ResolverBundle {
    protected AbstractBundleState bundleState;
    private boolean resolved;
    protected Map<String, ExportPackage> exportedPackages = new LinkedHashMap<String, ExportPackage>();
    protected Map<String, ImportPackage> importedPackages = new LinkedHashMap<String, ImportPackage>();
    protected Map<String, RequiredBundle> requiredBundles = new LinkedHashMap<String, RequiredBundle>();

    public AbstractResolverBundle(Bundle bundle) {
        this.bundleState = AbstractBundleState.assertBundleState(bundle);
    }

    @Override
    public Bundle getBundle() {
        return this.bundleState.getBundleInternal();
    }

    @Override
    public long getBundleId() {
        return this.bundleState.getBundleId();
    }

    @Override
    public String getSymbolicName() {
        return this.bundleState.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return this.bundleState.getVersion();
    }

    @Override
    public int getState() {
        return this.bundleState.getState();
    }

    @Override
    public ExportPackage getExportPackage(String packageName) {
        return this.exportedPackages.get(packageName);
    }

    @Override
    public List<ExportPackage> getExportPackages() {
        ArrayList<ExportPackage> values = new ArrayList<ExportPackage>(this.exportedPackages.values());
        return Collections.unmodifiableList(values);
    }

    @Override
    public ImportPackage getImportPackage(String packageName) {
        return this.importedPackages.get(packageName);
    }

    @Override
    public List<ImportPackage> getImportPackages() {
        ArrayList<ImportPackage> values = new ArrayList<ImportPackage>(this.importedPackages.values());
        return Collections.unmodifiableList(values);
    }

    @Override
    public List<RequiredBundle> getRequiredBundles() {
        ArrayList<RequiredBundle> values = new ArrayList<RequiredBundle>(this.requiredBundles.values());
        return Collections.unmodifiableList(values);
    }

    @Override
    public RequiredBundle getRequiredBundle(String symbolicName) {
        return this.requiredBundles.get(symbolicName);
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void markResolved() {
        this.resolved = true;
    }

    public String toShortString() {
        return this.getSymbolicName() + "-" + this.getVersion();
    }

    public String toString() {
        return "Bundle[" + this.toShortString() + "]";
    }
}

