/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.resolver.ExportPackage;
import org.jboss.osgi.framework.resolver.ImportPackage;
import org.jboss.osgi.framework.resolver.ResolverBundle;
import org.jboss.osgi.framework.resolver.internal.AbstractResolverBundle;
import org.jboss.osgi.framework.resolver.internal.NamedElementImpl;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPackageImpl
extends NamedElementImpl
implements ExportPackage {
    private Set<ImportPackage> importers = new HashSet<ImportPackage>();

    public ExportPackageImpl(ResolverBundle owner, ParameterizedAttribute attr) {
        super(owner, attr);
    }

    @Override
    public Version getVersion() {
        Parameter version = this.getParameterizedAttribute().getAttribute("version");
        return Version.parseVersion(version != null ? version.getValue().toString() : null);
    }

    @Override
    public Set<String> getUses() {
        return this.getDirectiveValues("uses");
    }

    @Override
    public Set<String> getExcludes() {
        Set<String> valueList = this.getDirectiveValues("exclude");
        return valueList.isEmpty() ? null : valueList;
    }

    @Override
    public Set<String> getIncludes() {
        Set<String> valueList = this.getDirectiveValues("include");
        return valueList.isEmpty() ? null : valueList;
    }

    @Override
    public Set<String> getMandatory() {
        return this.getDirectiveValues("mandatory");
    }

    private Set<String> getDirectiveValues(String key) {
        HashSet<String> valueList = new HashSet<String>();
        Parameter directive = this.getParameterizedAttribute().getDirective(key);
        if (directive != null) {
            Object value = directive.getValue();
            if (value instanceof Collection) {
                valueList.addAll((Collection)value);
            } else if (value instanceof String) {
                valueList.add((String)value);
            } else {
                throw new IllegalStateException("Invalid directive value: " + value);
            }
        }
        return Collections.unmodifiableSet(valueList);
    }

    @Override
    public boolean matchAttributes(ImportPackage importPackage) {
        if (importPackage == null) {
            throw new IllegalArgumentException("Null importPackage");
        }
        boolean match = true;
        Set<String> importAttributes = importPackage.getAttributes();
        Set<String> mandatoryAttributes = this.getMandatory();
        HashSet<String> ignoredAttributes = new HashSet<String>();
        ignoredAttributes.add("bundle-symbolic-name");
        ignoredAttributes.add("bundle-version");
        ignoredAttributes.add("version");
        for (String attrKey : importAttributes) {
            String expValue;
            if (ignoredAttributes.contains(attrKey)) continue;
            String impValue = (String)importPackage.getAttribute(attrKey);
            if (impValue != null) {
                impValue = impValue.trim();
            }
            if ((expValue = (String)this.getAttribute(attrKey)) != null) {
                expValue = expValue.trim();
            }
            if (impValue.equals(expValue)) continue;
            match = false;
            break;
        }
        for (String attrKey : mandatoryAttributes) {
            String expValue = (String)this.getAttribute(attrKey);
            if (expValue == null) {
                throw new IllegalStateException("Cannot get mandatory attribute value: " + attrKey);
            }
            String impValue = (String)importPackage.getAttribute(attrKey);
            if (impValue != null) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public Set<ImportPackage> getImporters() {
        return Collections.unmodifiableSet(this.importers);
    }

    @Override
    public void addImporter(ImportPackage importer) {
        this.importers.add(importer);
    }

    @Override
    public void removeImporter(ImportPackage importer) {
        this.importers.remove(importer);
    }

    @Override
    public String toShortString() {
        AbstractResolverBundle owner = (AbstractResolverBundle)this.getOwner();
        return owner.toShortString() + super.toShortString();
    }

    public String toString() {
        return "ExportPackage[" + this.toShortString() + "]";
    }
}

