/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.access;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;

public class PutFromLoadValidator {
    public static final long NAKED_PUT_INVALIDATION_PERIOD = 10000L;
    private static final long PENDING_PUT_OVERAGE_PERIOD = 5000L;
    private static final long PENDING_PUT_RECENT_PERIOD = 2000L;
    private static final long MAX_PENDING_PUT_DELAY = 120000L;
    private final TransactionManager transactionManager;
    private final long nakedPutInvalidationPeriod;
    private final long pendingPutOveragePeriod;
    private final long pendingPutRecentPeriod;
    private final long maxPendingPutDelay;
    private final ConcurrentMap<Object, PendingPutMap> pendingPuts = new ConcurrentHashMap<Object, PendingPutMap>();
    private final List<WeakReference<PendingPut>> pendingQueue = new LinkedList<WeakReference<PendingPut>>();
    private final List<WeakReference<PendingPut>> overagePendingQueue = new LinkedList<WeakReference<PendingPut>>();
    private final Lock pendingLock = new ReentrantLock();
    private final ConcurrentMap<Object, Long> recentRemovals = new ConcurrentHashMap<Object, Long>();
    private final List<RecentRemoval> removalsQueue = new LinkedList<RecentRemoval>();
    private volatile long earliestRemovalTimestamp;
    private final Lock removalsLock = new ReentrantLock();
    private volatile long invalidationTimestamp;

    public PutFromLoadValidator(TransactionManager transactionManager) {
        this(transactionManager, 10000L, 5000L, 2000L, 120000L);
    }

    protected PutFromLoadValidator(TransactionManager transactionManager, long nakedPutInvalidationPeriod, long pendingPutOveragePeriod, long pendingPutRecentPeriod, long maxPendingPutDelay) {
        this.transactionManager = transactionManager;
        this.nakedPutInvalidationPeriod = nakedPutInvalidationPeriod;
        this.pendingPutOveragePeriod = pendingPutOveragePeriod;
        this.pendingPutRecentPeriod = pendingPutRecentPeriod;
        this.maxPendingPutDelay = maxPendingPutDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPutValid(Object key) {
        Long removedTime;
        boolean valid = false;
        long now = System.currentTimeMillis();
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        if (pending != null) {
            PendingPutMap pendingPutMap = pending;
            synchronized (pendingPutMap) {
                PendingPut toCancel = pending.remove(this.getOwnerForPut());
                boolean bl = valid = toCancel != null;
                if (valid) {
                    toCancel.completed = true;
                    if (pending.size() == 0) {
                        this.pendingPuts.remove(key);
                    }
                }
            }
        }
        if (!(valid || now <= this.invalidationTimestamp || (removedTime = (Long)this.recentRemovals.get(key)) != null && now <= removedTime)) {
            valid = true;
        }
        this.cleanOutdatedPendingPuts(now, true);
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyRemoved(Object key) {
        Long cleaned;
        this.pendingPuts.remove(key);
        RecentRemoval removal = new RecentRemoval(key, this.nakedPutInvalidationPeriod);
        this.recentRemovals.put(key, removal.timestamp);
        RecentRemoval toClean = null;
        boolean attemptClean = removal.timestamp > this.earliestRemovalTimestamp;
        this.removalsLock.lock();
        try {
            this.removalsQueue.add(removal);
            if (attemptClean) {
                if (this.removalsQueue.size() > 1) {
                    toClean = this.removalsQueue.remove(0);
                }
                this.earliestRemovalTimestamp = this.removalsQueue.get(0).timestamp;
            }
        }
        finally {
            this.removalsLock.unlock();
        }
        if (toClean != null && (cleaned = (Long)this.recentRemovals.get(toClean.key)) != null && cleaned.equals(toClean.timestamp) && (cleaned = (Long)this.recentRemovals.remove(toClean.key)) != null && !cleaned.equals(toClean.timestamp)) {
            this.recentRemovals.putIfAbsent(toClean.key, cleaned);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionRemoved() {
        this.invalidationTimestamp = System.currentTimeMillis() + this.nakedPutInvalidationPeriod;
        this.pendingLock.lock();
        try {
            this.removalsLock.lock();
            try {
                this.pendingPuts.clear();
                this.pendingQueue.clear();
                this.overagePendingQueue.clear();
                this.recentRemovals.clear();
                this.removalsQueue.clear();
                this.earliestRemovalTimestamp = this.invalidationTimestamp;
            }
            finally {
                this.removalsLock.unlock();
            }
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPendingPut(Object key) {
        PendingPutMap pendingForKey;
        PendingPut pendingPut = new PendingPut(key, this.getOwnerForPut());
        PendingPutMap pendingPutMap = pendingForKey = new PendingPutMap();
        synchronized (pendingPutMap) {
            block8: {
                PendingPutMap existing;
                while ((existing = this.pendingPuts.putIfAbsent(key, pendingForKey)) != null && existing != pendingForKey) {
                    PendingPutMap pendingPutMap2 = existing;
                    synchronized (pendingPutMap2) {
                        existing.put(pendingPut);
                        PendingPutMap doublecheck = this.pendingPuts.putIfAbsent(key, existing);
                        if (doublecheck == null || doublecheck == existing) {
                            break block8;
                        }
                    }
                }
                pendingForKey.put(pendingPut);
            }
        }
        this.preventOutdatedPendingPuts(pendingPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPendingPutQueueLength() {
        this.pendingLock.lock();
        try {
            int n = this.pendingQueue.size();
            return n;
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getOveragePendingPutQueueLength() {
        this.pendingLock.lock();
        try {
            int n = this.overagePendingQueue.size();
            return n;
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemovalQueueLength() {
        this.removalsLock.lock();
        try {
            int n = this.removalsQueue.size();
            return n;
        }
        finally {
            this.removalsLock.unlock();
        }
    }

    private Object getOwnerForPut() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not obtain transaction", (Throwable)se);
        }
        return tx == null ? Thread.currentThread() : tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preventOutdatedPendingPuts(PendingPut pendingPut) {
        this.pendingLock.lock();
        try {
            this.pendingQueue.add(new WeakReference<PendingPut>(pendingPut));
            this.cleanOutdatedPendingPuts(pendingPut.timestamp, false);
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOutdatedPendingPuts(long now, boolean lock) {
        PendingPutMap map;
        Object toClean = null;
        if (lock) {
            this.pendingLock.lock();
        }
        try {
            long overaged = now - this.pendingPutOveragePeriod;
            long recent = now - this.pendingPutRecentPeriod;
            int pos = 0;
            while (this.pendingQueue.size() > pos) {
                WeakReference<PendingPut> ref = this.pendingQueue.get(pos);
                PendingPut item = (PendingPut)ref.get();
                if (item == null || item.completed) {
                    this.pendingQueue.remove(pos);
                    continue;
                }
                if (item.timestamp < overaged) {
                    this.pendingQueue.remove(pos);
                    this.overagePendingQueue.add(ref);
                    continue;
                }
                if (item.timestamp >= recent || pos > 2) break;
                ++pos;
            }
            long mustCleanTime = now - this.maxPendingPutDelay;
            while (this.overagePendingQueue.size() > 0) {
                WeakReference<PendingPut> ref = this.overagePendingQueue.get(0);
                PendingPut item = (PendingPut)ref.get();
                if (item == null || item.completed) {
                    this.overagePendingQueue.remove(0);
                    continue;
                }
                if (item.timestamp < mustCleanTime) {
                    this.overagePendingQueue.remove(0);
                    toClean = item;
                }
                break;
            }
        }
        finally {
            if (lock) {
                this.pendingLock.unlock();
            }
        }
        if (toClean != null && (map = (PendingPutMap)this.pendingPuts.get(((PendingPut)toClean).key)) != null) {
            PendingPutMap pendingPutMap = map;
            synchronized (pendingPutMap) {
                PendingPut cleaned = map.remove(((PendingPut)toClean).owner);
                if (!toClean.equals(cleaned)) {
                    map.put(cleaned);
                } else if (map.size() == 0) {
                    this.pendingPuts.remove(((PendingPut)toClean).key);
                }
            }
        }
    }

    private static class RecentRemoval {
        private final Object key;
        private final Long timestamp;

        private RecentRemoval(Object key, long nakedPutInvalidationPeriod) {
            this.key = key;
            this.timestamp = System.currentTimeMillis() + nakedPutInvalidationPeriod;
        }
    }

    private static class PendingPut {
        private final Object key;
        private final Object owner;
        private final long timestamp = System.currentTimeMillis();
        private volatile boolean completed;

        private PendingPut(Object key, Object owner) {
            this.key = key;
            this.owner = owner;
        }
    }

    private static class PendingPutMap {
        private PendingPut singlePendingPut;
        private Map<Object, PendingPut> fullMap;

        private PendingPutMap() {
        }

        public void put(PendingPut pendingPut) {
            if (this.singlePendingPut == null) {
                if (this.fullMap == null) {
                    this.singlePendingPut = pendingPut;
                } else {
                    this.fullMap.put(pendingPut.owner, pendingPut);
                }
            } else {
                this.fullMap = new HashMap<Object, PendingPut>(4);
                this.fullMap.put(this.singlePendingPut.owner, this.singlePendingPut);
                this.singlePendingPut = null;
                this.fullMap.put(pendingPut.owner, pendingPut);
            }
        }

        public PendingPut remove(Object ownerForPut) {
            PendingPut removed = null;
            if (this.fullMap == null) {
                if (this.singlePendingPut != null && this.singlePendingPut.owner.equals(ownerForPut)) {
                    removed = this.singlePendingPut;
                    this.singlePendingPut = null;
                }
            } else {
                removed = this.fullMap.remove(ownerForPut);
            }
            return removed;
        }

        public int size() {
            return this.fullMap == null ? (this.singlePendingPut == null ? 0 : 1) : this.fullMap.size();
        }
    }
}

