/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.managed;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.jboss.ha.framework.server.ChannelInfo;
import org.jboss.ha.framework.server.managed.ProtocolStackConfigMapper;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jgroups.Address;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenChannelsMapper
extends MetaMapper<Set<ChannelInfo>> {
    public static final MetaType OBJECT_NAME_TYPE;
    public static final CollectionMetaType PROTOCOL_OBJECT_NAMES_TYPE;
    public static final CollectionMetaType MEMBERS_TYPE;
    public static final CompositeMetaType VIEW_TYPE;
    public static final CompositeMetaType CHANNEL_TYPE;
    public static final CollectionMetaType TYPE;
    private static final ProtocolStackConfigMapper CONFIG_MAPPER;

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return Set.class;
    }

    public MetaValue createMetaValue(MetaType metaType, Set<ChannelInfo> object) {
        MetaValueFactory valueFactory = MetaValueFactory.getInstance();
        ArrayList<MapCompositeValueSupport> elements = new ArrayList<MapCompositeValueSupport>();
        for (ChannelInfo chInfo : object) {
            ObjectName on;
            HashMap<String, Object> data = new HashMap<String, Object>();
            String id = chInfo.getId();
            if (id != null) {
                data.put("id", SimpleValueSupport.wrap((Serializable)((Object)id)));
            }
            data.put("clusterName", SimpleValueSupport.wrap((Serializable)((Object)chInfo.getClusterName())));
            String stackName = chInfo.getStackName();
            if (stackName != null) {
                data.put("stackName", SimpleValueSupport.wrap((Serializable)((Object)stackName)));
            }
            if ((on = chInfo.getChannelObjectName()) != null) {
                data.put("channelObjectName", valueFactory.create((Object)on));
            }
            data.put("protocolStackConfiguration", CONFIG_MAPPER.createMetaValue(this.getMetaType(), chInfo.getProtocolStackConfiguration()));
            List<ObjectName> protNames = chInfo.getProtocolObjectNames();
            if (protNames != null) {
                ArrayList<MetaValue> onValues = new ArrayList<MetaValue>();
                for (ObjectName protON : protNames) {
                    onValues.add(valueFactory.create((Object)protON));
                }
                data.put("protocolObjectNames", new CollectionValueSupport(PROTOCOL_OBJECT_NAMES_TYPE, onValues.toArray(new MetaValue[onValues.size()])));
            }
            data.put("localAddress", SimpleValueSupport.wrap((Serializable)((Object)chInfo.getLocalAddress().toString())));
            MetaValue viewValue = this.createViewMetaValue(chInfo.getCurrentView());
            data.put("currentView", viewValue);
            elements.add(new MapCompositeValueSupport(data, (MetaType)CHANNEL_TYPE));
        }
        return new CollectionValueSupport(TYPE, elements.toArray(new MetaValue[elements.size()]));
    }

    private MetaValue createViewMetaValue(View view) {
        HashMap<String, Object> viewMap = new HashMap<String, Object>();
        viewMap.put("id", SimpleValueSupport.wrap((long)view.getVid().getId()));
        viewMap.put("creator", SimpleValueSupport.wrap((Serializable)((Object)view.getCreator().toString())));
        Vector members = view.getMembers();
        MetaValue[] memberValues = new MetaValue[members.size()];
        for (int i = 0; i < memberValues.length; ++i) {
            memberValues[i] = SimpleValueSupport.wrap((Serializable)((Object)((Address)members.get(i)).toString()));
        }
        viewMap.put("members", new CollectionValueSupport(MEMBERS_TYPE, memberValues));
        if (memberValues.length > 0) {
            viewMap.put("coordinator", memberValues[0]);
        }
        MapCompositeValueSupport viewValue = new MapCompositeValueSupport(viewMap, (MetaType)VIEW_TYPE);
        return viewValue;
    }

    public Set<ChannelInfo> unwrapMetaValue(MetaValue metaValue) {
        return null;
    }

    static {
        CONFIG_MAPPER = new ProtocolStackConfigMapper();
        OBJECT_NAME_TYPE = MetaTypeFactory.getInstance().resolve(ObjectName.class);
        PROTOCOL_OBJECT_NAMES_TYPE = new CollectionMetaType(List.class.getName(), OBJECT_NAME_TYPE);
        MEMBERS_TYPE = new CollectionMetaType(List.class.getName(), (MetaType)SimpleMetaType.STRING);
        String[] viewItemNames = new String[]{"id", "creator", "members", "coordinator", "payload"};
        String[] viewDescriptions = new String[]{"sequence number of the view", "Address of the node that issued the view", "Addresses of the group members", "Address of the node acting as group coordinator", "arbitrary information added by the application to the view"};
        MetaType[] viewItemTypes = new MetaType[]{SimpleMetaType.LONG_PRIMITIVE, SimpleMetaType.STRING, MEMBERS_TYPE, SimpleMetaType.STRING, SimpleMetaType.STRING};
        VIEW_TYPE = new ImmutableCompositeMetaType(View.class.getName(), "JGroups View", viewItemNames, viewDescriptions, viewItemTypes);
        String[] itemNames = new String[]{"id", "clusterName", "stackName", "protocolStackConfiguration", "channelObjectName", "protocolObjectNames", "localAddress", "currentView"};
        String[] itemDescriptions = new String[]{"id, if any, passed by the client when it requested the channel", "name of the cluster group, shared by all channels that form a group", "name, if any, of the protocol stack configuration that was used to create the channel", "the channel's protocol stack configuration", "ObjectName of the mbean that represents the channel, if the factory registered one", "ObjectNames of the mbeans that represent the channel's protocol, if the factory registered them", "Address of this node in the group", "the channel's current group membership view"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, CONFIG_MAPPER.getMetaType(), OBJECT_NAME_TYPE, PROTOCOL_OBJECT_NAMES_TYPE, SimpleMetaType.STRING, VIEW_TYPE};
        CHANNEL_TYPE = new ImmutableCompositeMetaType(ChannelInfo.class.getName(), "Channel", itemNames, itemDescriptions, itemTypes);
        TYPE = new CollectionMetaType(Set.class.getName(), (MetaType)CHANNEL_TYPE);
    }
}

