/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann;

import org.jboss.mcann.AnnotationScanner;
import org.jboss.mcann.repository.javassist.JavassistConfiguration;
import org.jboss.mcann.scanner.DefaultAnnotationScanner;

public class AnnotationScannerFactory {
    public static final int JAVA_LANG_REFLECT = 0;
    public static final int JAVASSIST = 1;
    private static int defaultStrategy;
    static boolean haveJavassist;

    private AnnotationScannerFactory() {
    }

    public static AnnotationScanner getDefault() {
        return AnnotationScannerFactory.getStrategy(defaultStrategy);
    }

    public static AnnotationScanner getStrategy(int strategy) {
        if (strategy >= 2) {
            throw new IllegalArgumentException("No such strategy: " + strategy);
        }
        DefaultAnnotationScanner scanner = new DefaultAnnotationScanner();
        if (strategy == 1) {
            scanner.setConfiguration(new JavassistConfiguration());
        }
        return scanner;
    }

    static {
        haveJavassist = false;
        try {
            Class.forName("javassist.CtClass");
            haveJavassist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        defaultStrategy = haveJavassist ? 1 : 0;
    }
}

