/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.repository;

import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.mcann.repository.Settings;
import org.jboss.reflect.spi.ClassInfo;

public abstract class AbstractSettings
implements Settings {
    private boolean ignoreIndex;
    private ResourceFilter resourceFilter = ClassFilter.INSTANCE;
    private boolean forceAnnotations;
    private boolean keepAnnotations;
    private boolean checkInterfaces;
    private boolean checkSuper;

    public AbstractSettings() {
    }

    public AbstractSettings(Settings configuration) {
        this.merge(configuration);
    }

    public void merge(Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Null settings.");
        }
        this.setIgnoreIndex(settings.ignoreIndex());
        this.setResourceFilter(settings.resourceFilter());
        this.setForceAnnotations(settings.failOnError());
        this.setKeepAnnotations(settings.keepAnnotations());
        this.setCheckSuper(settings.checkSuper());
        this.setCheckInterfaces(settings.checkInterfaces());
    }

    public boolean ignoreIndex() {
        return this.ignoreIndex;
    }

    public boolean isRelevant(ClassInfo classInfo) {
        return !Object.class.getName().equals(classInfo.getName());
    }

    public ResourceFilter resourceFilter() {
        return this.resourceFilter;
    }

    public boolean failOnError() {
        return this.forceAnnotations;
    }

    public boolean keepAnnotations() {
        return this.keepAnnotations;
    }

    public boolean checkSuper() {
        return this.checkSuper;
    }

    public boolean checkInterfaces() {
        return this.checkInterfaces;
    }

    public void setIgnoreIndex(boolean ignoreIndex) {
        this.ignoreIndex = ignoreIndex;
    }

    public void setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void setForceAnnotations(boolean forceAnnotations) {
        this.forceAnnotations = forceAnnotations;
    }

    public void setKeepAnnotations(boolean keepAnnotations) {
        this.keepAnnotations = keepAnnotations;
    }

    public void setCheckSuper(boolean checkSuper) {
        this.checkSuper = checkSuper;
    }

    public void setCheckInterfaces(boolean checkInterfaces) {
        this.checkInterfaces = checkInterfaces;
    }
}

