/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.repository;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.Element;
import org.jboss.mcann.GroupingStrategy;
import org.jboss.mcann.repository.AbstractElement;
import org.jboss.mcann.repository.ClassElement;
import org.jboss.mcann.repository.ClassSignaturePair;
import org.jboss.mcann.repository.DefaultElement;
import org.jboss.mcann.repository.MergeGroupingStrategy;
import org.jboss.mcann.repository.MutableAnnotationRepository;
import org.jboss.mcann.repository.ParametersElement;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.util.collection.ConcurrentReferenceHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationRepository
extends MutableAnnotationRepository
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> env;
    private transient Set<String> checkedClassNames;
    private boolean keepAnnotations;
    private Map<Object, Object> grouping = new ConcurrentReferenceHashMap();

    public DefaultAnnotationRepository(ClassLoader classLoader) {
        super(classLoader);
        this.env = new HashMap<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>();
        this.checkedClassNames = new HashSet<String>();
    }

    public void setKeepAnnotations(boolean keepAnnotations) {
        this.keepAnnotations = keepAnnotations;
    }

    protected Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> getEnv() {
        if (this.env == null) {
            throw new IllegalArgumentException("Null env, previously serialized?");
        }
        return this.env;
    }

    @Override
    boolean isAlreadyChecked(String className) {
        return this.checkedClassNames.contains(className);
    }

    @Override
    public void merge(AnnotationRepository repository) {
        this.group(new MergeGroupingStrategy(repository));
    }

    @Override
    public <T> T group(GroupingStrategy<T> strategy) {
        Object cached;
        if (strategy == null) {
            throw new IllegalArgumentException("Null strategy.");
        }
        if (strategy.useCache() && (cached = this.grouping.get(strategy.cacheKey())) != null) {
            return strategy.wrap(cached);
        }
        T result = strategy.group(this);
        if (result != null && strategy.putToCache()) {
            this.grouping.put(strategy.cacheKey(), result);
        }
        return result;
    }

    @Override
    void putAnnotation(Annotation annotation, ElementType type, String className, Signature signature) {
        this.putAnnotation(annotation, annotation.annotationType(), type, className, signature);
    }

    void putAnnotation(Annotation annotation, Class<? extends Annotation> annClass, ElementType type, String className, Signature signature) {
        Set classes;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Adding annotation @" + annClass.getSimpleName() + " for " + className + " at type " + (Object)((Object)type) + ", signature: " + signature));
        }
        this.checkedClassNames.add(className);
        Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> env = this.getEnv();
        Map<ElementType, Set<ClassSignaturePair>> elements = env.get(annClass);
        if (elements == null) {
            elements = new HashMap<ElementType, Set<ClassSignaturePair>>();
            env.put(annClass, elements);
        }
        if ((classes = elements.get((Object)type)) == null) {
            classes = CollectionsFactory.createLazySet();
            elements.put(type, classes);
        }
        ClassSignaturePair pair = this.keepAnnotations ? new ClassSignaturePair(className, signature, annotation) : new ClassSignaturePair(className, signature);
        classes.add(pair);
    }

    protected Set<ClassSignaturePair> getCSPairs(Class<? extends Annotation> annClass, ElementType type) {
        Set<ClassSignaturePair> pairs = null;
        Map<ElementType, Set<ClassSignaturePair>> elements = this.getEnv().get(annClass);
        if (elements != null) {
            pairs = elements.get((Object)type);
        }
        return pairs != null ? pairs : Collections.emptySet();
    }

    protected <A extends Annotation, M extends AnnotatedElement> Set<Element<A, M>> transformToElements(ElementType type, Class<A> annClass, Class<M> aoClass) {
        Set<ClassSignaturePair> pairs = this.getCSPairs(annClass, type);
        if (pairs.isEmpty()) {
            return Collections.emptySet();
        }
        ClassLoader classLoader = this.getClassLoader();
        HashSet<Element<A, M>> elements = new HashSet<Element<A, M>>();
        for (ClassSignaturePair pair : pairs) {
            String className = pair.getClassName();
            Annotation annotation = (Annotation)annClass.cast(pair.getAnnotation());
            AbstractElement element = type == ElementType.TYPE ? new ClassElement(classLoader, className, annClass, annotation) : (type == ElementType.PARAMETER ? new ParametersElement<Annotation, M>(classLoader, className, pair.getSignature(), annClass, annotation, aoClass) : new DefaultElement<Annotation, M>(classLoader, className, pair.getSignature(), annClass, annotation, aoClass));
            elements.add(element);
        }
        return elements;
    }

    @Override
    public boolean hasClassAnnotatedWith(Class<? extends Annotation> annotation) {
        return !this.getCSPairs(annotation, ElementType.TYPE).isEmpty();
    }

    @Override
    public <A extends Annotation> Set<Element<A, Class<?>>> classIsAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.TYPE, annotation, Class.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, Constructor<?>>> classHasConstructorAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.CONSTRUCTOR, annotation, Constructor.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, Field>> classHasFieldAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.FIELD, annotation, Field.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, Method>> classHasMethodAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.METHOD, annotation, Method.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, AnnotatedElement>> classHasParameterAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.PARAMETER, annotation, AnnotatedElement.class);
    }

    protected Class<Annotation> getAnnotationClass(String annotationName) {
        Class<Annotation> clazz = this.loadClass(annotationName);
        if (!Annotation.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Annotation name " + annotationName + " doesn't extend Annotation class.");
        }
        return clazz;
    }

    @Override
    public boolean hasClassAnnotatedWith(String annotationName) {
        return this.hasClassAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Class<?>>> classIsAnnotatedWith(String annotationName) {
        return this.classIsAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Constructor<?>>> classHasConstructorAnnotatedWith(String annotationName) {
        return this.classHasConstructorAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Field>> classHasFieldAnnotatedWith(String annotationName) {
        return this.classHasFieldAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Method>> classHasMethodAnnotatedWith(String annotationName) {
        return this.classHasMethodAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, AnnotatedElement>> classHasParameterAnnotatedWith(String annotationName) {
        return this.classHasParameterAnnotatedWith(this.getAnnotationClass(annotationName));
    }
}

