/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.repository;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.logging.Logger;
import org.jboss.mcann.repository.CommitElement;
import org.jboss.mcann.repository.MutableAnnotationRepository;
import org.jboss.mcann.repository.RepositoryPutList;
import org.jboss.mcann.repository.Settings;
import org.jboss.mcann.repository.TypeInfoProvider;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MemberInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAnnotationResourceVisitor
implements ResourceVisitor {
    private static final Logger log = Logger.getLogger(GenericAnnotationResourceVisitor.class);
    private MutableAnnotationRepository repository;
    private Settings settings;
    private TypeInfoProvider typeInfoProvider;

    public GenericAnnotationResourceVisitor(MutableAnnotationRepository repository, Settings settings, TypeInfoProvider typeInfoProvider) {
        if (repository == null) {
            throw new IllegalArgumentException("Null repository.");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Null configuration");
        }
        if (typeInfoProvider == null) {
            throw new IllegalArgumentException("Null type info");
        }
        this.repository = repository;
        this.settings = settings;
        this.typeInfoProvider = typeInfoProvider;
    }

    protected ClassInfo createClassInfo(ResourceContext context) throws Exception {
        TypeInfo typeInfo = this.typeInfoProvider.createTypeInfo(context);
        if (!(typeInfo instanceof ClassInfo)) {
            throw new IllegalArgumentException("Can only handle class info: " + typeInfo);
        }
        return (ClassInfo)ClassInfo.class.cast(typeInfo);
    }

    public ResourceFilter getFilter() {
        return this.settings.resourceFilter();
    }

    public void visit(ResourceContext resource) {
        try {
            ClassInfo ctClass = this.createClassInfo(resource);
            List<CommitElement> commit = this.createCommitList();
            this.handleClass(ctClass, commit);
            if (!commit.isEmpty()) {
                for (CommitElement ce : commit) {
                    this.repository.putAnnotation(ce.getAnnotation(), ce.getType(), ce.getClassName(), ce.getSignature());
                }
            }
        }
        catch (Throwable t) {
            if (this.settings.failOnError()) {
                throw new RuntimeException(t);
            }
            this.logThrowable(resource, t);
        }
    }

    protected List<CommitElement> createCommitList() {
        return this.settings.failOnError() ? new RepositoryPutList(this.repository) : new ArrayList();
    }

    protected void logThrowable(ResourceContext resource, Throwable t) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Exception reading resource: " + resource.getResourceName()), t);
        }
    }

    protected void handleClass(ClassInfo classInfo, List<CommitElement> commit) throws Exception {
        if (classInfo == null || !this.settings.isRelevant(classInfo)) {
            return;
        }
        String className = classInfo.getName();
        if (this.repository.isAlreadyChecked(className)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping already checked class name: " + className));
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scanning class " + className + " for annotations"));
        }
        Annotation[] annotations = classInfo.getUnderlyingAnnotations();
        GenericAnnotationResourceVisitor.handleAnnotations(ElementType.TYPE, (Signature)null, annotations, className, commit);
        this.handleMembers(ElementType.CONSTRUCTOR, (AnnotatedInfo[])classInfo.getDeclaredConstructors(), className, commit);
        this.handleMembers(ElementType.METHOD, (AnnotatedInfo[])classInfo.getDeclaredMethods(), className, commit);
        this.handleMembers(ElementType.FIELD, (AnnotatedInfo[])classInfo.getDeclaredFields(), className, commit);
        boolean checkInterfaces = this.settings.checkInterfaces();
        boolean checkSuper = this.settings.checkSuper();
        if (checkInterfaces || checkSuper) {
            InterfaceInfo[] interfaces;
            if (checkInterfaces && (interfaces = classInfo.getInterfaces()) != null && interfaces.length > 0) {
                for (InterfaceInfo intf : interfaces) {
                    this.handleClass((ClassInfo)intf, commit);
                }
            }
            if (checkSuper) {
                this.handleClass(classInfo.getSuperclass(), commit);
            }
        }
    }

    protected void handleMembers(ElementType type, AnnotatedInfo[] members, String className, List<CommitElement> commit) throws Exception {
        if (members != null && members.length > 0) {
            for (AnnotatedInfo ainfo : members) {
                if (!(ainfo instanceof MemberInfo)) {
                    throw new IllegalArgumentException("Can only handle member info: " + ainfo);
                }
                Annotation[] annotations = ainfo.getUnderlyingAnnotations();
                MemberInfo member = (MemberInfo)MemberInfo.class.cast(ainfo);
                GenericAnnotationResourceVisitor.handleAnnotations(type, member, annotations, className, commit);
                if (!this.isParametrized(ainfo)) continue;
                Annotation[][] paramAnnotations = this.getParameterAnnotations(member);
                for (int index = 0; index < paramAnnotations.length; ++index) {
                    Signature signature = this.getParameterSignature(member, index);
                    GenericAnnotationResourceVisitor.handleAnnotations(ElementType.PARAMETER, signature, paramAnnotations[index], className, commit);
                }
            }
        }
    }

    protected boolean isParametrized(AnnotatedInfo member) {
        return member instanceof MethodInfo || member instanceof ConstructorInfo;
    }

    protected Annotation[][] getParameterAnnotations(MemberInfo info) {
        ParameterInfo[] pinfos;
        if (info instanceof ConstructorInfo) {
            ConstructorInfo ci = (ConstructorInfo)ConstructorInfo.class.cast(info);
            pinfos = ci.getParameters();
        } else if (info instanceof MethodInfo) {
            MethodInfo mi = (MethodInfo)MethodInfo.class.cast(info);
            pinfos = mi.getParameters();
        } else {
            throw new IllegalArgumentException("Cannot handle info: " + info);
        }
        Annotation[][] values = new Annotation[pinfos.length][];
        for (int i = 0; i < pinfos.length; ++i) {
            ParameterInfo pi = pinfos[i];
            values[i] = pi.getUnderlyingAnnotations();
        }
        return values;
    }

    protected Signature getParameterSignature(MemberInfo info, int index) {
        if (info instanceof ConstructorInfo) {
            ConstructorInfo ci = (ConstructorInfo)ConstructorInfo.class.cast(info);
            return new ConstructorParametersSignature(ci, index);
        }
        if (info instanceof MethodInfo) {
            MethodInfo mi = (MethodInfo)MethodInfo.class.cast(info);
            return new MethodParametersSignature(mi, index);
        }
        throw new IllegalArgumentException("Cannot handle info: " + info);
    }

    protected static void handleAnnotations(ElementType type, MemberInfo member, Annotation[] annotations, String className, List<CommitElement> commit) throws Exception {
        Signature signature = null;
        if (member != null) {
            signature = Signature.getSignature((MemberInfo)member);
        }
        GenericAnnotationResourceVisitor.handleAnnotations(type, signature, annotations, className, commit);
    }

    protected static void handleAnnotations(ElementType type, Signature signature, Annotation[] annotations, String className, List<CommitElement> commit) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                commit.add(new CommitElement(annotation, type, className, signature));
            }
        }
    }
}

