/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.repository.javassist;

import java.io.InputStream;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.mcann.repository.TypeInfoProvider;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.classpool.ClassPoolFactory;
import org.jboss.reflect.spi.TypeInfo;

public class JavassistTypeInfoProvider
implements TypeInfoProvider {
    private ClassPool pool;
    private ClassPath path;

    public JavassistTypeInfoProvider() {
    }

    public JavassistTypeInfoProvider(ClassPool pool) {
        this.pool = pool;
    }

    public void beforeVisit(ClassLoader classLoader) {
        if (this.pool == null) {
            ClassPoolFactory factory = JavassistTypeInfoFactoryImpl.getPoolFactory();
            ClassPool cp = factory.getPoolForLoader(classLoader);
            ClassPool defaultCP = ClassPool.getDefault();
            if (cp == null || cp == defaultCP) {
                cp = new ClassPool();
                this.path = new LoaderClassPath(classLoader);
                cp.appendClassPath(this.path);
            }
            this.pool = cp;
        }
    }

    public void afterVisit(ClassLoader classLoader) {
        if (this.path != null) {
            ClassPool cp = this.pool;
            this.pool = null;
            cp.removeClassPath(this.path);
            this.path = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeInfo createTypeInfo(ResourceContext context) throws Exception {
        InputStream stream = context.getInputStream();
        if (stream == null) {
            throw new IllegalArgumentException("Null stream: " + context);
        }
        try {
            CtClass ctClass = this.pool.makeClassIfNew(stream);
            TypeInfo typeInfo = JavassistUtil.toTypeInfo((CtClass)ctClass);
            return typeInfo;
        }
        finally {
            stream.close();
        }
    }
}

