/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.ImmutableProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.BasicDeploymentRepository;
import org.jboss.system.server.profileservice.repository.HotDeploymentRepository;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDeploymentRepositoryFactory
implements DeploymentRepositoryFactory {
    public static final String MUTABLE_TYPE = HotDeploymentProfileSourceMetaData.class.getName();
    public static final String IMMUTABLE_TYPE = ImmutableProfileSourceMetaData.class.getName();
    public static final Collection<String> types = Arrays.asList(MUTABLE_TYPE, IMMUTABLE_TYPE);
    private List<URI> uploadURIs;
    private boolean failIfAlreadyExists = false;
    private VirtualFileFilter deploymentFilter;
    private StructureModificationChecker checker;

    public String[] getTypes() {
        return types.toArray(new String[types.size()]);
    }

    public VirtualFileFilter getDeploymentFilter() {
        return this.deploymentFilter;
    }

    public void setDeploymentFilter(VirtualFileFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    public boolean isFailIfAlreadyExists() {
        return this.failIfAlreadyExists;
    }

    public void setFailIfAlreadyExists(boolean failIfAlreadyExists) {
        this.failIfAlreadyExists = failIfAlreadyExists;
    }

    public List<URI> getUploadURIs() {
        return this.uploadURIs;
    }

    public void setUploadURIs(List<URI> uploadURIs) {
        this.uploadURIs = uploadURIs;
    }

    public StructureModificationChecker getChecker() {
        return this.checker;
    }

    public void setChecker(StructureModificationChecker checker) {
        this.checker = checker;
    }

    public DeploymentRepository createDeploymentRepository(ProfileKey key, ProfileSourceMetaData metaData) throws Exception {
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        String repositoryType = metaData.getType();
        if (repositoryType == null) {
            throw new IllegalArgumentException("Null repository type.");
        }
        if (!types.contains(repositoryType)) {
            throw new IllegalArgumentException("Cannot handle type: " + repositoryType);
        }
        boolean mutable = false;
        if (repositoryType.equals(MUTABLE_TYPE)) {
            mutable = true;
        }
        return this.createDeploymentRepository(mutable, key, this.createUris(metaData));
    }

    protected DeploymentRepository createDeploymentRepository(boolean mutable, ProfileKey key, URI[] uris) throws Exception {
        BasicDeploymentRepository repository;
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (uris == null) {
            throw new IllegalArgumentException("Null uris");
        }
        if (mutable) {
            repository = new HotDeploymentRepository(key, uris);
            ((HotDeploymentRepository)repository).setChecker(this.checker);
        } else {
            repository = new BasicDeploymentRepository(key, uris);
        }
        this.setUploadURI(repository);
        repository.setDeploymentFilter(this.deploymentFilter);
        repository.setFailIfAlreadyExists(this.isFailIfAlreadyExists());
        return repository;
    }

    protected void setUploadURI(BasicDeploymentRepository repository) {
        URI[] repositoryURIs;
        if (this.uploadURIs != null && !this.uploadURIs.isEmpty() && (repositoryURIs = repository.getRepositoryURIs()) != null && repositoryURIs.length > 0) {
            for (URI repositoryURI : repositoryURIs) {
                if (!this.uploadURIs.contains(repositoryURI)) continue;
                repository.setUploadUri(repositoryURI);
            }
        }
    }

    protected URI[] createUris(ProfileSourceMetaData metaData) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String source : metaData.getSources()) {
            URI uri = new URI(source);
            uris.add(uri);
        }
        return uris.toArray(new URI[uris.size()]);
    }
}

