/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.clustered.local.ContentMetadataPersister;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManager;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManagerFactory;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FilesystemLocalContentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemLocalContentManagerFactory
implements LocalContentManagerFactory<FileBasedSynchronizationActionContext> {
    private ContentMetadataPersister metadataPersister;
    private URI tempDirURI;

    public ContentMetadataPersister getMetadataPersister() {
        return this.metadataPersister;
    }

    public void setMetadataPersister(ContentMetadataPersister metadataPersister) {
        this.metadataPersister = metadataPersister;
    }

    public URI getTempDirURI() {
        return this.tempDirURI;
    }

    public void setTempDirURI(URI tempDirURI) {
        this.tempDirURI = tempDirURI;
    }

    @Override
    public boolean accepts(Collection<URI> uris) {
        try {
            FilesystemLocalContentManagerFactory.testURIs(uris);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public LocalContentManager<FileBasedSynchronizationActionContext> getLocalContentManager(Map<String, URI> namedURIMap, ProfileKey profileKey, String localNodeName) {
        if (this.metadataPersister == null) {
            throw new IllegalStateException("Null metadataPersister; must configure a " + ContentMetadataPersister.class.getSimpleName());
        }
        FilesystemLocalContentManagerFactory.testURIs(namedURIMap.values());
        return new FilesystemLocalContentManager(namedURIMap, profileKey, localNodeName, this.metadataPersister, this.tempDirURI);
    }

    private static void testURIs(Collection<URI> uris) {
        for (URI uri : uris) {
            File f = new File(uri);
            if (f.exists()) continue;
            throw new IllegalArgumentException("No file found for URI " + uri);
        }
    }
}

