/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.util.Iterator;
import org.jboss.interceptor.model.metadata.ClassReference;
import org.jboss.interceptor.model.metadata.ImmutableIteratorWrapper;
import org.jboss.interceptor.model.metadata.MethodReference;
import org.jboss.weld.bean.interceptor.WeldMethodReference;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldClassReference
implements ClassReference {
    private WeldClass<?> weldClass;

    private WeldClassReference(WeldClass<?> weldClass) {
        this.weldClass = weldClass;
    }

    public static ClassReference of(WeldClass<?> weldClass) {
        return new WeldClassReference(weldClass);
    }

    public String getClassName() {
        return this.weldClass.getName();
    }

    public Iterable<MethodReference> getDeclaredMethods() {
        return new Iterable<MethodReference>(){

            @Override
            public Iterator<MethodReference> iterator() {
                return new ImmutableIteratorWrapper<WeldMethod<?, ?>>(WeldClassReference.this.weldClass.getDeclaredWeldMethods().iterator()){

                    protected MethodReference wrapObject(WeldMethod<?, ?> weldMethod) {
                        return WeldMethodReference.of(weldMethod);
                    }
                };
            }
        };
    }

    public Class<?> getJavaClass() {
        return this.weldClass.getJavaClass();
    }

    public ClassReference getSuperclass() {
        WeldClass<?> weldSuperclass = this.weldClass.getWeldSuperclass();
        if (weldSuperclass != null) {
            return WeldClassReference.of(weldSuperclass);
        }
        return null;
    }
}

