/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.lang.annotation.Annotation;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.Container;
import org.jboss.weld.context.AbstractContext;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.exceptions.ForbiddenArgumentException;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapContext
extends AbstractContext {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private static ReentrantLock creationLock = new ReentrantLock();

    public AbstractMapContext(Class<? extends Annotation> scopeType) {
        super(scopeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (this.getBeanStore() == null) {
            return null;
        }
        if (contextual == null) {
            throw new ForbiddenArgumentException(ContextMessage.CONTEXTUAL_IS_NULL, new Object[0]);
        }
        String id = AbstractMapContext.getId(contextual);
        Object beanInstance = this.getBeanStore().get(id);
        if (beanInstance != null) {
            return (T)beanInstance.getInstance();
        }
        if (creationalContext != null) {
            boolean needCreationLock = this.isCreationLockRequired();
            try {
                Object instance;
                if (needCreationLock) {
                    creationLock.lock();
                    beanInstance = this.getBeanStore().get(id);
                    if (beanInstance != null) {
                        Object object = beanInstance.getInstance();
                        return (T)object;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableContextualInstanceImpl<Contextual<T>, Object>(contextual, instance, creationalContext);
                    this.getBeanStore().put(id, beanInstance);
                }
                Object object = instance;
                return (T)object;
            }
            finally {
                if (needCreationLock) {
                    creationLock.unlock();
                }
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private <T> void destroy(String id) {
        if (this.getBeanStore() == null) {
            throw new ForbiddenStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        ContextualInstance beanInstance = this.getBeanStore().get(id);
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
        log.trace((Enum)ContextMessage.CONTEXTUAL_INSTANCE_REMOVED, new Object[]{id, this});
    }

    public void destroy() {
        log.trace((Enum)ContextMessage.CONTEXT_CLEARED, new Object[]{this});
        if (this.getBeanStore() == null) {
            throw new ForbiddenStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        for (String id : this.getBeanStore().getContextualIds()) {
            this.destroy(id);
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    protected abstract boolean isCreationLockRequired();

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.getBeanStore() != null) {
            this.getBeanStore().clear();
        }
    }

    protected static <T> Contextual<T> getContextual(String id) {
        return ((ContextualStore)Container.instance().services().get(ContextualStore.class)).getContextual(id);
    }

    protected static String getId(Contextual<?> contextual) {
        return ((ContextualStore)Container.instance().services().get(ContextualStore.class)).putIfAbsent(contextual);
    }
}

