/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableFactory {
    public static Resolvable of(WeldAnnotated<?, ?> element) {
        if (element instanceof Resolvable) {
            return (Resolvable)((Object)element);
        }
        HashSet<Type> types = new HashSet<Type>();
        types.add(element.getBaseType());
        return new ResolvableImpl(element.getQualifiers(), types, null);
    }

    public static Resolvable of(Set<Type> typeClosure, Set<Annotation> bindings, AbstractClassBean<?> declaringBean) {
        return new ResolvableImpl(bindings, typeClosure, declaringBean);
    }

    public static Resolvable of(Set<Type> typeClosure, AbstractClassBean<?> declaringBean, Annotation ... bindings) {
        return new ResolvableImpl(new HashSet<Annotation>(Arrays.asList(bindings)), typeClosure, declaringBean);
    }

    public static InterceptorResolvable of(InterceptionType interceptionType, Annotation ... bindings) {
        return new InterceptorResolvableImpl(new HashSet<Annotation>(Arrays.asList(bindings)), interceptionType);
    }

    private ResolvableFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterceptorResolvableImpl
    extends ResolvableImpl
    implements InterceptorResolvable {
        private final InterceptionType interceptionType;

        private InterceptorResolvableImpl(Set<Annotation> bindings, InterceptionType interceptionType) {
            super(bindings, Collections.singleton(Object.class), null);
            this.interceptionType = interceptionType;
        }

        @Override
        public InterceptionType getInterceptionType() {
            return this.interceptionType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvableImpl
    implements Resolvable {
        private final Set<Annotation> bindings;
        private final Map<Class<? extends Annotation>, Annotation> annotations;
        private final Set<Type> typeClosure;
        private final AbstractClassBean<?> declaringBean;

        public ResolvableImpl(Set<Annotation> bindings, Set<Type> typeClosure, AbstractClassBean<?> declaringBean) {
            this.bindings = bindings;
            if (bindings.size() == 0) {
                this.bindings.add((Annotation)DefaultLiteral.INSTANCE);
            }
            this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            this.typeClosure = typeClosure;
            for (Annotation annotation : bindings) {
                this.annotations.put(annotation.annotationType(), annotation);
            }
            this.declaringBean = declaringBean;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.bindings;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.containsKey(annotationType);
        }

        @Override
        public Set<Type> getTypeClosure() {
            return this.typeClosure;
        }

        @Override
        public boolean isAssignableTo(Class<?> clazz) {
            return Reflections.isAssignableFrom(clazz, this.typeClosure);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)this.annotations.get(annotationType);
        }

        @Override
        public Class<?> getJavaClass() {
            return null;
        }

        @Override
        public AbstractClassBean<?> getDeclaringBean() {
            return this.declaringBean;
        }

        public String toString() {
            return "Types: " + this.getTypeClosure() + "; Bindings: " + this.getQualifiers();
        }
    }
}

