/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.EntityManagerFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.jboss.ejb3.jpa.integration.AbstractSessionFactoryDelegator;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.util.ManagedEntityManagerFactoryHelper;

public class InjectedSessionFactory
extends AbstractSessionFactoryDelegator
implements SessionFactory,
Externalizable {
    private static final long serialVersionUID = 7866450655332120010L;
    private transient EntityManagerFactory delegate;
    private transient ManagedEntityManagerFactory managedFactory;

    public InjectedSessionFactory(ManagedEntityManagerFactory factory) {
        this.managedFactory = factory;
        this.delegate = factory.getEntityManagerFactory();
    }

    public InjectedSessionFactory() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.managedFactory.getKernelName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        this.managedFactory = ManagedEntityManagerFactoryHelper.getManagedEntityManagerFactory((String)kernelName);
        if (this.managedFactory == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.delegate = this.managedFactory.getEntityManagerFactory();
    }

    private EntityManagerFactory getDelegate() {
        return this.delegate;
    }

    protected SessionFactory getSessionFactory() {
        return ((HibernateEntityManagerFactory)this.getDelegate()).getSessionFactory();
    }

    public void close() throws HibernateException {
        throw new IllegalStateException("It is illegal to close an injected SessionFactory");
    }
}

