/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCallByMethod;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodByMethodInfo
extends CallerMethodInfo
implements MethodCallByMethod {
    private final long callingMethodHash;
    private final Method callingMethod;

    public MethodByMethodInfo(Advisor advisor, Class<?> calledClass, Method m, Method callingMethod, long callingMethodHash, long calledMethodHash, Interceptor[] in) {
        super(advisor, calledClass, m, calledMethodHash, in, callingMethod.getDeclaringClass());
        this.callingMethodHash = callingMethodHash;
        this.callingMethod = callingMethod;
    }

    private MethodByMethodInfo(MethodByMethodInfo other) {
        super(other);
        this.callingMethodHash = other.callingMethodHash;
        this.callingMethod = other.callingMethod;
    }

    @Override
    protected Joinpoint internalGetJoinpoint() {
        return new MethodCalledByMethodJoinpoint(this.callingMethod, this.getMethod());
    }

    @Override
    public JoinPointInfo copy() {
        return new MethodByMethodInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method called by Method");
        sb.append("[");
        sb.append("calling=" + this.callingMethod);
        sb.append(",called=" + this.getMethod());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public long getCallingMethodHash() {
        return this.callingMethodHash;
    }

    @Override
    public Method getCallingMethod() {
        return this.callingMethod;
    }
}

