/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.LocalDatagramConnector;
import org.jboss.xnio.LocalServer;
import org.jboss.xnio.LocalStreamConnector;
import org.jboss.xnio.ManagedServerSocketFactory;
import org.jboss.xnio.ManagedSocketFactory;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.SslEngineSslTcpServer;
import org.jboss.xnio.SslTcpConnector;
import org.jboss.xnio.SslTcpServer;
import org.jboss.xnio.TcpAcceptor;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.TcpServer;
import org.jboss.xnio.UdpServer;
import org.jboss.xnio.Version;
import org.jboss.xnio.XnioConfiguration;
import org.jboss.xnio.XnioProvider;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.ConnectedStreamChannel;
import org.jboss.xnio.channels.DatagramChannel;
import org.jboss.xnio.channels.SslTcpChannel;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.OneWayPipeConnectionMBean;
import org.jboss.xnio.management.PipeConnectionMBean;
import org.jboss.xnio.management.PipeServerMBean;
import org.jboss.xnio.management.PipeSinkServerMBean;
import org.jboss.xnio.management.PipeSourceServerMBean;
import org.jboss.xnio.management.TcpConnectionMBean;
import org.jboss.xnio.management.TcpServerMBean;
import org.jboss.xnio.management.UdpServerMBean;

public abstract class Xnio
implements Closeable {
    private static final Logger mlog = Logger.getLogger("org.jboss.xnio.management");
    private static final String NIO_IMPL_PROVIDER = "nio";
    private static final String PROVIDER_NAME;
    private static final String MANAGEMENT_DOMAIN = "jboss.xnio";
    private static final String PROPERTIES = "xnio.properties";
    private static final AtomicLong mbeanSequence;
    private static String AGENTID_PROPNAME;
    private static String PROVIDER_PROPNAME;
    private static String PROPERTY_FILE_PROPNAME;
    private static final PrivilegedAction<String> GET_PROVIDER_ACTION;
    private static final PrivilegedAction<String> GET_AGENTID_ACTION;
    private static final Permission SUBCLASS_PERMISSION;
    private final List<MBeanServer> mBeanServers = new ArrayList<MBeanServer>();
    private final String name;
    private final Executor executor;
    private static final Map<String, Xnio> instanceMap;
    private static final AtomicInteger xnioSequence;

    static {
        Logger.getLogger("org.jboss.xnio").info("XNIO Version " + Version.VERSION);
        mbeanSequence = new AtomicLong();
        AGENTID_PROPNAME = "xnio.agentid";
        PROVIDER_PROPNAME = "xnio.provider.name";
        PROPERTY_FILE_PROPNAME = "xnio.property.file";
        GET_PROVIDER_ACTION = new GetPropertyAction(PROVIDER_PROPNAME, NIO_IMPL_PROVIDER);
        GET_AGENTID_ACTION = new GetPropertyAction(AGENTID_PROPNAME, null);
        SUBCLASS_PERMISSION = new RuntimePermission("xnioProvider");
        String providerClassName = NIO_IMPL_PROVIDER;
        try {
            providerClassName = AccessController.doPrivileged(GET_PROVIDER_ACTION);
        }
        catch (Throwable throwable) {}
        PROVIDER_NAME = providerClassName;
        instanceMap = new HashMap<String, Xnio>();
        xnioSequence = new AtomicInteger(1);
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xnio getInstance(String name) throws IOException {
        Map<String, Xnio> map = instanceMap;
        synchronized (map) {
            Xnio instance = instanceMap.get(name);
            if (instance != null) {
                return instance;
            }
            Xnio newInstance = Xnio.createConfigured(name);
            instanceMap.put(name, newInstance);
            return newInstance;
        }
    }

    public static Xnio getInstance() throws IOException {
        return Xnio.getInstance("default");
    }

    private static Xnio createConfigured(final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Xnio>(){

                @Override
                public Xnio run() {
                    Properties props;
                    block11: {
                        String fileName = System.getProperty(PROPERTY_FILE_PROPNAME, Xnio.PROPERTIES);
                        props = new Properties();
                        try {
                            InputStream stream = this.getClass().getResourceAsStream(fileName);
                            if (stream == null) break block11;
                            try {
                                InputStreamReader reader = new InputStreamReader(stream, "utf-8");
                                try {
                                    props.load(reader);
                                    reader.close();
                                }
                                finally {
                                    IoUtils.safeClose(reader);
                                }
                            }
                            finally {
                                IoUtils.safeClose(stream);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    XnioConfiguration conf = new XnioConfiguration();
                    if (Boolean.parseBoolean(props.getProperty(String.valueOf(name) + ".listener.threadpool", "false"))) {
                        conf.setExecutor(new ThreadPoolExecutor(Integer.parseInt(props.getProperty(String.valueOf(name) + ".listener.threadpool.coresize", "8")), Integer.parseInt(props.getProperty(String.valueOf(name) + ".listener.threadpool.maxsize", "64")), Long.parseLong(props.getProperty(String.valueOf(name) + ".listener.threadpool.keepaliveseconds", "30")), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(Integer.parseInt(props.getProperty(String.valueOf(name) + ".listener.threadpool.queuelength", "64"))), new ThreadPoolExecutor.CallerRunsPolicy()));
                    }
                    conf.setName(name);
                    conf.setOptionMap(OptionMap.builder().parseAll(props, String.valueOf(name) + ".provider.option.").getMap());
                    try {
                        return Xnio.create(props.getProperty(String.valueOf(name) + ".provider", PROVIDER_NAME), conf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw e;
        }
    }

    public static Xnio create() throws IOException {
        return Xnio.create(PROVIDER_NAME, new XnioConfiguration());
    }

    public static Xnio create(XnioConfiguration configuration) throws IOException {
        return Xnio.create(PROVIDER_NAME, configuration);
    }

    public static Xnio create(String implName, XnioConfiguration configuration) throws IOException {
        for (XnioProvider xnioProvider : ServiceLoader.load(XnioProvider.class)) {
            if (!implName.equals(xnioProvider.getName())) continue;
            return xnioProvider.getNewInstance(configuration);
        }
        throw new IOException("No XNIO provider named \"" + implName + "\" could be found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xnio(XnioConfiguration configuration) {
        List<MBeanServer> servers;
        if (configuration == null) {
            throw new NullPointerException("configuration is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_PERMISSION);
        }
        String name = configuration.getName();
        int seq = xnioSequence.getAndIncrement();
        this.name = name != null ? name : String.format("%s-%d", this.getClass().getName(), seq);
        Executor executor = configuration.getExecutor();
        this.executor = executor != null ? executor : IoUtils.directExecutor();
        List<MBeanServer> list = servers = this.mBeanServers;
        synchronized (list) {
            List<MBeanServer> confServers = configuration.getMBeanServers();
            if (confServers != null) {
                for (MBeanServer server : confServers) {
                    if (server == null) {
                        throw new NullPointerException("server in MBeanServer configuration list is null");
                    }
                    mlog.debug("Registered configured MBeanServer %s", (Object)server);
                    servers.add(server);
                }
            } else {
                String agentidpropval;
                try {
                    agentidpropval = sm != null ? AccessController.doPrivileged(GET_AGENTID_ACTION) : System.getProperty(AGENTID_PROPNAME);
                }
                catch (SecurityException e) {
                    mlog.debug("Unable to read agentid property (%s); JMX features disabled", (Object)e);
                    return;
                }
                if (agentidpropval == null || agentidpropval.length() == 0) {
                    ArrayList<MBeanServer> fullList;
                    try {
                        fullList = sm != null ? AccessController.doPrivileged(new GetMBeanServersAction(null)) : MBeanServerFactory.findMBeanServer(null);
                    }
                    catch (SecurityException e) {
                        mlog.debug("Unable to detect installed mbean servers (%s); JMX features disabled", (Object)e);
                        return;
                    }
                    for (MBeanServer match : fullList) {
                        mlog.debug("Registered MBeanServer %s", (Object)match);
                        servers.add(match);
                    }
                } else {
                    String[] agentids;
                    String[] stringArray = agentids = agentidpropval.split(",");
                    int n = agentids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block23: {
                            String agentid = stringArray[n2];
                            String properName = agentid.trim();
                            if (properName.length() != 0) {
                                ArrayList<MBeanServer> matches;
                                try {
                                    matches = sm != null ? AccessController.doPrivileged(new GetMBeanServersAction(properName)) : MBeanServerFactory.findMBeanServer(null);
                                }
                                catch (SecurityException e) {
                                    mlog.debug("Unable to locate any MBeanServer for ID \"%s\" (%s); skipping", (Object)properName, (Object)e);
                                    break block23;
                                }
                                if (matches == null) {
                                    mlog.debug("Unable to locate any MBeanServer for ID \"%s\" (no matches); skipping", (Object)properName);
                                } else {
                                    for (MBeanServer match : matches) {
                                        mlog.debug("Registered MBeanServer %s for ID \"%s\"", (Object)match, (Object)properName);
                                        servers.add(match);
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public SocketFactory createManagedSocketFactory(OptionMap optionMap) {
        return new ManagedSocketFactory(this, optionMap);
    }

    public ServerSocketFactory createServerSocketFactory(OptionMap optionMap) {
        return new ManagedServerSocketFactory(this, optionMap);
    }

    public TcpServer createTcpServer(Executor executor, ChannelListener<? super TcpChannel> openListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("TCP Server");
    }

    public TcpServer createTcpServer(ChannelListener<? super TcpChannel> openListener, OptionMap optionMap) {
        return this.createTcpServer(this.executor, openListener, optionMap);
    }

    public SslTcpServer createSslTcpServer(Executor executor, ChannelListener<? super SslTcpChannel> openListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        SSLContext sslContext = this.getSSLContext(optionMap);
        SslEngineSslTcpServer server = new SslEngineSslTcpServer(sslContext, this.createTcpServer(executor, null, optionMap), executor, optionMap);
        if (openListener != null) {
            server.getOpenSetter().set(openListener);
        }
        return server;
    }

    private SSLContext getSSLContext(OptionMap optionMap) throws NoSuchAlgorithmException, NoSuchProviderException {
        String provider = optionMap.get(Options.SSL_PROVIDER);
        String protocol = optionMap.get(Options.SSL_PROTOCOL);
        SSLContext sslContext = protocol == null ? SSLContext.getDefault() : (provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider));
        return sslContext;
    }

    public SslTcpServer createSslTcpServer(ChannelListener<? super SslTcpChannel> openListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.createSslTcpServer(this.executor, openListener, optionMap);
    }

    public SslTcpServer createSslTcpServer(OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.createSslTcpServer(null, optionMap);
    }

    public TcpConnector createTcpConnector(Executor executor, OptionMap optionMap) {
        return this.createTcpConnector(executor, null, optionMap);
    }

    public TcpConnector createTcpConnector(OptionMap optionMap) {
        return this.createTcpConnector(this.executor, optionMap);
    }

    public TcpConnector createTcpConnector(Executor executor, InetSocketAddress src, OptionMap optionMap) {
        throw new UnsupportedOperationException("TCP Connector");
    }

    public TcpConnector createTcpConnector(InetSocketAddress src, OptionMap optionMap) {
        return this.createTcpConnector(this.executor, src, optionMap);
    }

    public SslTcpConnector createSslTcpConnector(final Executor executor, InetSocketAddress src, final OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        final SSLContext sslContext = this.getSSLContext(optionMap);
        final TcpConnector connector = this.createTcpConnector(executor, src, optionMap);
        return new SslTcpConnector(){

            @Override
            public IoFuture<SslTcpChannel> connectTo(InetSocketAddress destination, final ChannelListener<? super SslTcpChannel> openListener, ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener) {
                final FutureResult futureResult = new FutureResult(executor);
                connector.connectTo(destination, (ChannelListener<? super TcpChannel>)new ChannelListener<TcpChannel>(){

                    @Override
                    public void handleEvent(TcpChannel tcpChannel) {
                        SslTcpChannel channel = Channels.createSslTcpChannel(sslContext, tcpChannel, executor, optionMap);
                        futureResult.setResult(channel);
                        IoUtils.invokeChannelListener(channel, openListener);
                    }
                }, bindListener).addNotifier(new IoFuture.HandlingNotifier<TcpChannel, FutureResult<SslTcpChannel>>(){

                    @Override
                    public void handleCancelled(FutureResult<SslTcpChannel> result) {
                        result.setCancelled();
                    }

                    @Override
                    public void handleFailed(IOException exception, FutureResult<SslTcpChannel> result) {
                        result.setException(exception);
                    }
                }, futureResult);
                return futureResult.getIoFuture();
            }

            @Override
            public ChannelSource<SslTcpChannel> createChannelSource(final InetSocketAddress destination) {
                return new ChannelSource<SslTcpChannel>(){

                    @Override
                    public IoFuture<? extends SslTcpChannel> open(ChannelListener<? super SslTcpChannel> openListener) {
                        return this.connectTo(destination, openListener, (ChannelListener<? super BoundChannel<InetSocketAddress>>)null);
                    }
                };
            }
        };
    }

    public SslTcpConnector createSslTcpConnector(InetSocketAddress src, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.createSslTcpConnector(this.executor, src, optionMap);
    }

    public SslTcpConnector createSslTcpConnector(OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.createSslTcpConnector(this.executor, null, optionMap);
    }

    public UdpServer createUdpServer(Executor executor, ChannelListener<? super UdpChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("UDP Server");
    }

    public UdpServer createUdpServer(ChannelListener<? super UdpChannel> bindListener, OptionMap optionMap) {
        return this.createUdpServer(this.executor, bindListener, optionMap);
    }

    public UdpServer createUdpServer(OptionMap optionMap) {
        return this.createUdpServer(this.executor, IoUtils.nullChannelListener(), optionMap);
    }

    public ChannelSource<? extends StreamChannel> createPipeServer(Executor executor, ChannelListener<? super StreamChannel> openListener) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<? extends StreamChannel> createPipeServer(ChannelListener<? super StreamChannel> openListener) {
        return this.createPipeServer(this.executor, openListener);
    }

    public ChannelSource<? extends StreamSourceChannel> createPipeSourceServer(Executor executor, ChannelListener<? super StreamSinkChannel> openListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<? extends StreamSourceChannel> createPipeSourceServer(ChannelListener<? super StreamSinkChannel> openListener) {
        return this.createPipeSourceServer(this.executor, openListener);
    }

    public ChannelSource<? extends StreamSinkChannel> createPipeSinkServer(Executor executor, ChannelListener<? super StreamSourceChannel> openListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<? extends StreamSinkChannel> createPipeSinkServer(ChannelListener<? super StreamSourceChannel> openListener) {
        return this.createPipeSinkServer(this.executor, openListener);
    }

    public IoFuture<? extends Closeable> createPipeConnection(Executor executor, ChannelListener<? super StreamChannel> leftListener, ChannelListener<? super StreamChannel> rightListener) {
        throw new UnsupportedOperationException("Pipe Connection");
    }

    public IoFuture<? extends Closeable> createPipeConnection(ChannelListener<? super StreamChannel> leftListener, ChannelListener<? super StreamChannel> rightListener) {
        return this.createPipeConnection(this.executor, leftListener, rightListener);
    }

    public IoFuture<? extends Closeable> createOneWayPipeConnection(Executor executor, ChannelListener<? super StreamSourceChannel> sourceListener, ChannelListener<? super StreamSinkChannel> sinkListener) {
        throw new UnsupportedOperationException("One-way Pipe Connection");
    }

    public IoFuture<? extends Closeable> createOneWayPipeConnection(ChannelListener<? super StreamSourceChannel> sourceListener, ChannelListener<? super StreamSinkChannel> sinkListener) {
        return this.createOneWayPipeConnection(this.executor, sourceListener, sinkListener);
    }

    public TcpAcceptor createTcpAcceptor(Executor executor, OptionMap optionMap) {
        throw new UnsupportedOperationException("TCP Acceptor");
    }

    public TcpAcceptor createTcpAcceptor(OptionMap optionMap) {
        return this.createTcpAcceptor(this.executor, optionMap);
    }

    public LocalServer createLocalStreamServer(Executor executor, ChannelListener<? super ConnectedStreamChannel<String>> openListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Local IPC Stream Server");
    }

    public LocalServer createLocalStreamServer(ChannelListener<? super ConnectedStreamChannel<String>> openListener, OptionMap optionMap) {
        return this.createLocalStreamServer(this.executor, openListener, optionMap);
    }

    public LocalStreamConnector createLocalStreamConnector(Executor executor, OptionMap optionMap) {
        throw new UnsupportedOperationException("Local IPC Stream Connector");
    }

    public LocalStreamConnector createLocalStreamConnector(OptionMap optionMap) {
        return this.createLocalStreamConnector(this.executor, optionMap);
    }

    public LocalServer createLocalDatagramServer(Executor executor, ChannelListener<? super DatagramChannel<String>> openListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Local IPC Datagram Server");
    }

    public LocalServer createLocalDatagramServer(ChannelListener<? super DatagramChannel<String>> openListener, OptionMap optionMap) {
        return this.createLocalDatagramServer(this.executor, openListener, optionMap);
    }

    public LocalDatagramConnector createLocalDatagramConnector(Executor executor, OptionMap optionMap) {
        throw new UnsupportedOperationException("Local IPC Datagram Connector");
    }

    public LocalDatagramConnector createLocalDatagramConnector(OptionMap optionMap) {
        return this.createLocalDatagramConnector(this.executor, optionMap);
    }

    public void awaken(Thread targetThread) {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("XNIO provider \"%s\" <%s@%s>", this.getName(), this.getClass().getName(), Integer.toHexString(this.hashCode()));
    }

    @Override
    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Closeable registerMBean(final Object mBean, final ObjectName mBeanName) {
        List<MBeanServer> servers;
        SecurityManager sm = System.getSecurityManager();
        List<MBeanServer> list = servers = this.mBeanServers;
        synchronized (list) {
            Iterator<MBeanServer> it = servers.iterator();
            if (!it.hasNext()) {
                return IoUtils.nullCloseable();
            }
            final ArrayList<Registration> registrations = new ArrayList<Registration>(servers.size());
            do {
                final MBeanServer server = it.next();
                if (sm != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            Xnio.doRegister(mBean, mBeanName, registrations, server);
                            return null;
                        }
                    });
                    continue;
                }
                Xnio.doRegister(mBean, mBeanName, registrations, server);
            } while (it.hasNext());
            return new RegHandle(registrations);
        }
    }

    private static void doRegister(Object mBean, ObjectName mBeanName, List<Registration> registrations, MBeanServer server) {
        try {
            ObjectInstance instance = server.registerMBean(mBean, mBeanName);
            registrations.add(new Registration(server, instance.getObjectName()));
        }
        catch (JMException e) {
            mlog.debug((Throwable)e, "Failed to register mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
        }
        catch (RuntimeOperationsException e) {
            mlog.debug((Throwable)e, "Failed to register mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
        }
    }

    private static Entry entry(final String k, final String v) {
        return new Entry(){

            @Override
            public String getKey() {
                return k;
            }

            @Override
            public String getValue() {
                return v;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private static Hashtable<String, String> hashtable(Entry ... entries) {
        Hashtable<String, String> table = new Hashtable<String, String>(entries.length);
        Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            table.put((String)entry.getKey(), (String)entry.getValue());
            ++n2;
        }
        return table;
    }

    protected String getProperty(String name) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, null));
        }
        return System.getProperty(name);
    }

    protected String getProperty(String name, String defaultValue) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, defaultValue));
        }
        return System.getProperty(name, defaultValue);
    }

    protected Closeable registerMBean(TcpServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "tcp"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(TcpConnectionMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "connection"), Xnio.entry("protocol", "tcp"), Xnio.entry("bindAddress", ObjectName.quote(mBean.getBindAddress().toString())), Xnio.entry("peerAddress", ObjectName.quote(mBean.getPeerAddress().toString())), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(UdpServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "udp"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(OneWayPipeConnectionMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "connection"), Xnio.entry("protocol", "local"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeConnectionMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "connection"), Xnio.entry("protocol", "local"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "local"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeSourceServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "local-source"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeSinkServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "local-sink"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    private static interface Entry
    extends Map.Entry<String, String> {
    }

    private static final class GetMBeanServersAction
    implements PrivilegedAction<Collection<? extends MBeanServer>> {
        private final String agentId;

        public GetMBeanServersAction(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public Collection<? extends MBeanServer> run() {
            return MBeanServerFactory.findMBeanServer(this.agentId);
        }
    }

    private static final class GetPropertyAction
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        private GetPropertyAction(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }

    private static final class RegHandle
    implements Closeable {
        private final List<Registration> registrations;
        private final AtomicBoolean open = new AtomicBoolean(true);

        private RegHandle(List<Registration> registrations) {
            this.registrations = registrations;
        }

        @Override
        public void close() throws IOException {
            if (this.open.getAndSet(false)) {
                SecurityManager sm = System.getSecurityManager();
                for (final Registration registration : this.registrations) {
                    if (sm != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                RegHandle.doUnregister(registration);
                                return null;
                            }
                        });
                        continue;
                    }
                    RegHandle.doUnregister(registration);
                }
            }
        }

        private static void doUnregister(Registration registration) {
            MBeanServer server = registration.server;
            ObjectName mBeanName = registration.objectName;
            try {
                server.unregisterMBean(mBeanName);
            }
            catch (InstanceNotFoundException e) {
                mlog.debug((Throwable)e, "Failed to unregister mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
            }
            catch (MBeanRegistrationException e) {
                mlog.debug((Throwable)e, "Failed to unregister mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
            }
        }
    }

    private static final class Registration {
        private final MBeanServer server;
        private final ObjectName objectName;

        private Registration(MBeanServer server, ObjectName objectName) {
            this.server = server;
            this.objectName = objectName;
        }
    }
}

