/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Header;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.util.Util;

public class MuxHeader
extends Header {
    String id = null;
    ServiceInfo info;

    public MuxHeader() {
    }

    public MuxHeader(String id) {
        this.id = id;
    }

    public MuxHeader(ServiceInfo info) {
        this.info = info;
    }

    public String getId() {
        return this.id;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.info);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.info = (ServiceInfo)in.readObject();
    }

    @Override
    public int size() {
        int retval = 1;
        if (this.id != null) {
            retval += this.id.length() + 2;
        }
        ++retval;
        if (this.info != null) {
            retval = (int)((long)retval + this.info.size());
        }
        return retval;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        Util.writeString(this.id, out);
        if (this.info != null) {
            out.writeBoolean(true);
            this.info.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.id = Util.readString(in);
        if (in.readBoolean()) {
            this.info = new ServiceInfo();
            this.info.readFrom(in);
        }
    }

    @Override
    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        if (this.info != null) {
            return this.info.toString();
        }
        return "";
    }
}

