/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Header;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Util;

public class PingHeader
extends Header {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    public byte type = 0;
    public PingData arg = null;
    public String cluster_name = null;
    public boolean return_view_only = false;

    public PingHeader() {
    }

    public PingHeader(byte type, String cluster_name) {
        this.type = type;
        this.cluster_name = cluster_name;
    }

    public PingHeader(byte type, PingData arg) {
        this.type = type;
        this.arg = arg;
    }

    public PingHeader(byte type, PingData arg, String cluster_name) {
        this(type, arg);
        this.cluster_name = cluster_name;
    }

    @Override
    public int size() {
        int retval = 4;
        if (this.arg != null) {
            retval += this.arg.size();
        }
        if (this.cluster_name != null) {
            retval += this.cluster_name.length() + 2;
        }
        return retval;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[PING: type=" + PingHeader.type2Str(this.type));
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (this.arg != null) {
            sb.append(", arg=" + this.arg);
        }
        sb.append(']');
        return sb.toString();
    }

    static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unkown type (" + t + ")>";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeBoolean(this.return_view_only);
        out.writeObject(this.arg);
        out.writeObject(this.cluster_name);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.return_view_only = in.readBoolean();
        this.arg = (PingData)in.readObject();
        this.cluster_name = (String)in.readObject();
    }

    @Override
    public void writeTo(DataOutputStream outstream) throws IOException {
        outstream.writeByte(this.type);
        outstream.writeBoolean(this.return_view_only);
        Util.writeStreamable(this.arg, outstream);
        Util.writeString(this.cluster_name, outstream);
    }

    @Override
    public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
        this.type = instream.readByte();
        this.return_view_only = instream.readBoolean();
        this.arg = (PingData)Util.readStreamable(PingData.class, instream);
        this.cluster_name = Util.readString(instream);
    }
}

