/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Promise;
import org.jgroups.util.UUID;

public class TCPPING
extends Discovery {
    @Property(description="Number of ports to be probed for initial membership. Default is 1")
    private int port_range = 1;
    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts.class, dependsUpon="port_range", systemProperty={"jgroups.tcpping.initial_hosts"})
    private List<IpAddress> initial_hosts = null;
    @Property(description="max number of hosts to keep beyond the ones in initial_hosts")
    protected int max_dynamic_hosts = 100;
    protected final BoundedList<PhysicalAddress> dynamic_hosts = new BoundedList(this.max_dynamic_hosts);

    public TCPPING() {
        this.return_entire_cache = true;
    }

    public List<IpAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    public void setInitialHosts(List<IpAddress> initial_hosts) {
        this.initial_hosts = initial_hosts;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public void setPortRange(int port_range) {
        this.port_range = port_range;
    }

    @ManagedAttribute
    public String getDynamicHostList() {
        return this.dynamic_hosts.toString();
    }

    @ManagedAttribute
    public String getInitialHostsList() {
        return this.initial_hosts.toString();
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void sendGetMembersRequest(String cluster_name, Promise promise, boolean return_views_only) throws Exception {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), Arrays.asList(physical_addr));
        PingHeader hdr = new PingHeader(1, data, cluster_name);
        hdr.return_view_only = return_views_only;
        HashSet<IpAddress> combined_target_members = new HashSet<IpAddress>(this.initial_hosts);
        combined_target_members.addAll(this.dynamic_hosts);
        for (final PhysicalAddress physicalAddress : combined_target_members) {
            if (physicalAddress.equals(physical_addr)) continue;
            final Message msg = new Message((Address)physicalAddress, null, null);
            msg.setFlag((byte)1);
            msg.putHeader(this.id, hdr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
            }
            this.timer.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            TCPPING.this.down_prot.down(new Event(1, msg));
                        }
                        catch (Exception ex) {
                            if (!TCPPING.this.log.isErrorEnabled()) break block2;
                            TCPPING.this.log.error("failed sending discovery request to " + physicalAddress + ": " + ex);
                        }
                    }
                }
            });
        }
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.members) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, logical_addr));
                    if (physical_addr == null || this.initial_hosts.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent(physical_addr);
                }
                break;
            }
        }
        return retval;
    }
}

