/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    @Property(description="Number of millisecs to wait for a response from a suspected member")
    private long timeout = 2000L;
    @Property(description="Number of verify heartbeats sent to a suspected member")
    private int num_msgs = 1;
    @Property(description="Use InetAddress.isReachable() to verify suspected member instead of regular messages")
    private boolean use_icmp = false;
    @Property(description="Interface for ICMP pings. Used if use_icmp is true", systemProperty={"jgroups.bind_addr", "bind.address"}, defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS")
    private InetAddress bind_addr;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str = null;
    private NetworkInterface intf = null;
    private Address local_addr = null;
    private final Hashtable<Address, Long> suspects = new Hashtable();
    private Thread timer = null;

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 8) {
            this.local_addr = (Address)evt.getArg();
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                if (suspected_mbr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("suspected member is null");
                    }
                    return null;
                }
                if (this.local_addr != null && this.local_addr.equals(suspected_mbr)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("I was suspected; ignoring SUSPECT message");
                    }
                    return null;
                }
                if (!this.use_icmp) {
                    this.verifySuspect(suspected_mbr);
                } else {
                    this.verifySuspectWithICMP(suspected_mbr);
                }
                return null;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                VerifyHeader hdr = (VerifyHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("ARE_YOU_DEAD: hdr.from is null");
                            }
                        } else {
                            for (int i = 0; i < this.num_msgs; ++i) {
                                Message rsp = new Message(hdr.from, null, null);
                                rsp.setFlag((byte)1);
                                rsp.putHeader(this.id, new VerifyHeader(2, this.local_addr));
                                this.down_prot.down(new Event(1, rsp));
                            }
                        }
                        return null;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("I_AM_NOT_DEAD: hdr.from is null");
                            }
                            return null;
                        }
                        this.unsuspect(hdr.from);
                        return null;
                    }
                }
                return null;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.suspects.isEmpty()) {
            long diff = 0L;
            LinkedList<Address> confirmed_suspects = new LinkedList<Address>();
            Hashtable<Address, Long> hashtable = this.suspects;
            synchronized (hashtable) {
                Enumeration<Address> e = this.suspects.keys();
                while (e.hasMoreElements()) {
                    Address mbr = e.nextElement();
                    long val = this.suspects.get(mbr);
                    diff = System.currentTimeMillis() - val;
                    if (diff >= this.timeout) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("diff=" + diff + ", mbr " + mbr + " is dead (passing up SUSPECT event)");
                        }
                        confirmed_suspects.add(mbr);
                        this.suspects.remove(mbr);
                        continue;
                    }
                    diff = Math.max(diff, this.timeout - diff);
                }
            }
            for (Address suspect : confirmed_suspects) {
                this.up_prot.up(new Event(9, suspect));
            }
            if (diff <= 0L) continue;
            Util.sleep(diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifySuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        Hashtable<Address, Long> hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                return;
            }
            this.suspects.put(mbr, new Long(System.currentTimeMillis()));
        }
        this.startTimer();
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifying that " + mbr + " is dead");
        }
        for (int i = 0; i < this.num_msgs; ++i) {
            Message msg = new Message(mbr, null, null);
            msg.setFlag((byte)1);
            msg.putHeader(this.id, new VerifyHeader(1, this.local_addr));
            this.down_prot.down(new Event(1, msg));
        }
    }

    void verifySuspectWithICMP(Address suspected_mbr) {
        block8: {
            InetAddress host;
            InetAddress inetAddress = host = suspected_mbr instanceof IpAddress ? ((IpAddress)suspected_mbr).getIpAddress() : null;
            if (host == null) {
                throw new IllegalArgumentException("suspected_mbr is not of type IpAddress - FD_ICMP only works with these");
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("pinging host " + suspected_mbr + " using interface " + this.intf);
                }
                long start = System.currentTimeMillis();
                boolean rc = host.isReachable(this.intf, 0, (int)this.timeout);
                long stop = System.currentTimeMillis();
                if (rc) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("successfully received response from " + host + " (after " + (stop - start) + "ms)");
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.debug("could not ping " + suspected_mbr + " after " + (stop - start) + "ms; " + "passing up SUSPECT event");
                    }
                    this.suspects.remove(suspected_mbr);
                    this.up_prot.up(new Event(9, suspected_mbr));
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error("failed pinging " + suspected_mbr, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        boolean removed = false;
        Hashtable<Address, Long> hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("member " + mbr + " is not dead !");
                }
                this.suspects.remove(mbr);
                removed = true;
            }
        }
        if (removed) {
            this.down_prot.down(new Event(51, mbr));
            this.up_prot.up(new Event(51, mbr));
        }
    }

    private synchronized void startTimer() {
        if (this.timer == null || !this.timer.isAlive()) {
            this.timer = this.getThreadFactory().newThread(this, "VERIFY_SUSPECT.TimerThread");
            this.timer.setDaemon(true);
            this.timer.start();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            this.intf = NetworkInterface.getByInetAddress(this.bind_addr);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
        this.timer = null;
    }

    public static class VerifyHeader
    extends Header {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from = null;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.type);
            out.writeObject(this.from);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = (Address)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }
    }
}

