/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.jgroups.Header;
import org.jgroups.util.Headers;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=false)
public class HeadersTest {
    private static final short UDP_ID = 1;
    private static final short FRAG_ID = 2;
    private static final short NAKACK_ID = 3;
    private static final MyHeader h1 = new MyHeader();
    private static final MyHeader h2 = new MyHeader();
    private static final MyHeader h3 = new MyHeader();

    public static void testConstructor() {
        Headers hdrs = new Headers(5);
        System.out.println("hdrs = " + hdrs);
        assert (hdrs.capacity() == 5) : "capacity must be 5 but was " + hdrs.capacity();
        short[] ids = hdrs.getRawIDs();
        assert (ids.length == hdrs.capacity());
        Header[] headers = hdrs.getRawHeaders();
        assert (headers.length == hdrs.capacity());
        assert (hdrs.size() == 0);
    }

    public static void testContructor2() {
        Headers old = HeadersTest.createHeaders(3);
        Headers hdrs = new Headers(old);
        System.out.println("hdrs = " + hdrs);
        assert (hdrs.capacity() == 3) : "capacity must be 3 but was " + hdrs.capacity();
        short[] ids = hdrs.getRawIDs();
        Header[] headers = hdrs.getRawHeaders();
        assert (ids.length == hdrs.capacity());
        assert (headers.length == hdrs.capacity());
        assert (hdrs.size() == 3);
        old.putHeader((short)300, new MyHeader());
        assert (hdrs.capacity() == 3) : "capacity must be 3 but was " + hdrs.capacity();
        assert (ids.length == hdrs.capacity());
        assert (headers.length == hdrs.capacity());
        assert (hdrs.size() == 3);
    }

    public static void testGetRawData() {
        Headers hdrs = HeadersTest.createHeaders(3);
        short[] ids = hdrs.getRawIDs();
        Header[] headers = hdrs.getRawHeaders();
        assert (ids.length == 3);
        assert (headers.length == 3);
        assert (ids[0] == 3);
        assert (headers[0] == h1);
        assert (ids[1] == 2);
        assert (headers[1] == h2);
        assert (ids[2] == 1);
        assert (headers[2] == h3);
        assert (ids.length == hdrs.capacity());
        assert (headers.length == hdrs.capacity());
        assert (hdrs.size() == 3);
    }

    public static void testGetHeaders() {
        Headers hdrs = HeadersTest.createHeaders(3);
        Map<Short, Header> map = hdrs.getHeaders();
        System.out.println("map = " + map);
        assert (map != null && map.size() == 3);
        assert (map.get((short)3) == h1);
        assert (map.get((short)2) == h2);
        assert (map.get((short)1) == h3);
    }

    public static void testSize() {
        Headers hdrs = HeadersTest.createHeaders(3);
        assert (hdrs.size() == 3);
    }

    private static Headers createHeaders(int initial_capacity) {
        Headers hdrs = new Headers(initial_capacity);
        hdrs.putHeader((short)3, h1);
        hdrs.putHeader((short)2, h2);
        hdrs.putHeader((short)1, h3);
        return hdrs;
    }

    public static void testPutHeader() {
        Headers hdrs = HeadersTest.createHeaders(3);
        assert (hdrs.getHeader((short)3) == h1);
        hdrs.putHeader((short)3, new MyHeader());
        assert (hdrs.size() == 3);
        assert (hdrs.getHeader((short)3) != h1);
        assert (hdrs.capacity() == 3);
        hdrs.putHeader((short)400, new MyHeader());
        assert (hdrs.size() == 4);
        assert (hdrs.capacity() > 3);
    }

    public static void testPutHeaderIfAbsent() {
        Headers hdrs = HeadersTest.createHeaders(3);
        Header hdr = hdrs.putHeaderIfAbsent((short)2, new MyHeader());
        assert (hdr == h2);
        assert (hdr == hdrs.getHeader((short)2));
        assert (hdrs.size() == 3);
        assert (hdrs.capacity() == 3);
        hdr = hdrs.putHeaderIfAbsent((short)400, new MyHeader());
        System.out.println("hdrs = " + hdrs);
        assert (hdr == null);
        assert (hdrs.size() == 4);
        assert (hdrs.capacity() == 6);
    }

    public static void testGetHeader() {
        Headers hdrs = HeadersTest.createHeaders(3);
        assert (null == hdrs.getHeader((short)400));
        assert (hdrs.getHeader((short)1) == h3);
    }

    public static void testResize() {
        Headers hdrs = HeadersTest.createHeaders(3);
        int capacity = hdrs.capacity();
        System.out.println("hdrs = " + hdrs + ", capacity=" + capacity);
        hdrs.putHeader((short)400, new MyHeader());
        System.out.println("hdrs = " + hdrs + ", capacity=" + hdrs.capacity());
        assert (hdrs.capacity() > capacity);
        capacity = hdrs.capacity();
        for (int i = 10; i <= 13; ++i) {
            hdrs.putHeader((short)i, new MyHeader());
        }
        System.out.println("hdrs = " + hdrs + ", capacity=" + hdrs.capacity());
        assert (hdrs.capacity() > capacity);
    }

    public static class MyHeader
    extends Header {
        @Override
        public String toString() {
            return "MyHeader";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        }
    }
}

