/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.JChannel;
import org.jgroups.blocks.ReplicatedHashMap;
import org.jgroups.tests.ChannelTestBase;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class ReplicatedHashMapTest
extends ChannelTestBase {
    private ReplicatedHashMap<String, String> map1;
    private ReplicatedHashMap<String, String> map2;
    private ConcurrentHashMap<String, String> wrap = new ConcurrentHashMap();

    @BeforeClass
    protected void setUp() throws Exception {
        JChannel c1 = this.createChannel(true, 2);
        this.map1 = new ReplicatedHashMap(c1, false);
        this.map1.setBlockingUpdates(true);
        c1.connect("ReplicatedHashMapTest");
        this.map1.start(5000L);
        JChannel c2 = this.createChannel(c1);
        this.map2 = new ReplicatedHashMap<String, String>(this.wrap, c2, false);
        this.map2.setBlockingUpdates(true);
        c2.connect("ReplicatedHashMapTest");
        this.map2.start(5000L);
    }

    @AfterMethod
    protected void clean() {
        this.map1.clear();
        this.map2.clear();
    }

    @AfterClass
    protected void tearDown() throws Exception {
        this.map1.stop();
        this.map2.stop();
    }

    public void testEqualsEtc() {
        this.map1.put("key1", "value1");
        ReplicatedHashMapTest.assertEquals(this.map1, this.map2);
        Assert.assertEquals((int)this.map1.hashCode(), (int)this.map2.hashCode());
        Assert.assertEquals((String)this.map1.toString(), (String)this.map2.toString());
        ReplicatedHashMapTest.assertEquals(this.wrap, this.map1);
    }

    public void testSize() {
        Assert.assertEquals((int)0, (int)this.map1.size());
        Assert.assertEquals((int)this.map2.size(), (int)this.map1.size());
        this.map1.put("key1", "value1");
        Assert.assertEquals((int)1, (int)this.map1.size());
        Assert.assertEquals((int)this.map2.size(), (int)this.map1.size());
        this.map2.put("key2", "value2");
        Assert.assertEquals((int)2, (int)this.map1.size());
        Assert.assertEquals((int)this.map2.size(), (int)this.map1.size());
    }

    public void testIsEmpty() {
        ReplicatedHashMapTest.assertTrue(this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue(this.map2.isEmpty());
        this.map1.put("key", "value");
        ReplicatedHashMapTest.assertFalse(this.map1.isEmpty());
        ReplicatedHashMapTest.assertFalse(this.map2.isEmpty());
    }

    public void testContainsKey() {
        ReplicatedHashMapTest.assertFalse(this.map1.containsKey("key1"));
        ReplicatedHashMapTest.assertFalse(this.map2.containsKey("key1"));
        this.map1.put("key1", "value");
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("key1"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsKey("key1"));
        this.map2.put("key2", "value");
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("key2"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsKey("key2"));
    }

    public void testContainsValue() {
        ReplicatedHashMapTest.assertFalse(this.map1.containsValue("value1"));
        ReplicatedHashMapTest.assertFalse(this.map2.containsValue("value1"));
        this.map1.put("key1", "value1");
        ReplicatedHashMapTest.assertTrue(this.map1.containsValue("value1"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsValue("value1"));
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertTrue(this.map1.containsValue("value2"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsValue("value2"));
    }

    public void testPutAndGet() {
        assert (this.map1.get("key1") == null);
        assert (this.map2.get("key1") == null);
        this.map1.put("key1", "value1");
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key1"));
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key2"));
    }

    public void testPutIfAbsent() {
        String retval = this.map1.putIfAbsent("name", "Bela");
        assert (retval == null);
        retval = this.map1.putIfAbsent("name", "Michelle");
        ReplicatedHashMapTest.assertNotNull(retval);
        Assert.assertEquals((String)"Bela", (String)retval);
        Assert.assertEquals((String)"Bela", (String)((String)this.map1.get("name")));
        Assert.assertEquals((String)"Bela", (String)((String)this.map2.get("name")));
    }

    public void testRemove() {
        assert (this.map1.get("key1") == null);
        assert (this.map2.get("key1") == null);
        this.map1.put("key1", "value1");
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key2"));
        this.map1.remove("key1");
        assert (this.map1.get("key1") == null);
        assert (this.map2.get("key1") == null);
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key2"));
        this.map2.remove("key2");
        assert (this.map1.get("key2") == null);
        assert (this.map2.get("key2") == null);
    }

    public void testRemove2() {
        this.map1.put("name", "Bela");
        this.map1.put("id", "322649");
        System.out.println("map1: " + this.map1);
        boolean removed = this.map1.remove("id", "322000");
        ReplicatedHashMapTest.assertFalse(removed);
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("id"));
        removed = this.map1.remove("id", "322649");
        System.out.println("map1: " + this.map1);
        ReplicatedHashMapTest.assertTrue(removed);
        ReplicatedHashMapTest.assertFalse(this.map1.containsKey("id"));
        Assert.assertEquals((int)1, (int)this.map2.size());
    }

    public void testReplace() {
        this.map1.put("name", "Bela");
        this.map1.put("id", "322649");
        System.out.println("map1: " + this.map1);
        String val = this.map1.replace("id2", "322000");
        Assert.assertEquals((int)2, (int)this.map1.size());
        assert (this.map1.get("id2") == null);
        System.out.println("map1: " + this.map1);
        assert (val == null);
        val = this.map1.replace("id", "322000");
        System.out.println("map1: " + this.map1);
        ReplicatedHashMapTest.assertNotNull(val);
        Assert.assertEquals((String)"322649", (String)val);
        Assert.assertEquals((String)"322000", (String)((String)this.map1.get("id")));
        Assert.assertEquals((String)"322000", (String)((String)this.map2.get("id")));
    }

    public void testReplace2() {
        this.map1.put("name", "Bela");
        this.map1.put("id", "322649");
        System.out.println("map1: " + this.map1);
        boolean replaced = this.map1.replace("id", "322000", "1");
        ReplicatedHashMapTest.assertFalse(replaced);
        Assert.assertEquals((String)"322649", (String)((String)this.map1.get("id")));
        replaced = this.map1.replace("id", "322649", "1");
        ReplicatedHashMapTest.assertTrue(replaced);
        Assert.assertEquals((String)"1", (String)((String)this.map1.get("id")));
    }

    public void testPutAll() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        Assert.assertEquals((int)2, (int)this.map1.size());
        Assert.assertEquals((int)2, (int)this.map2.size());
        this.map2.putAll(all2);
        Assert.assertEquals((int)4, (int)this.map1.size());
        Assert.assertEquals((int)4, (int)this.map2.size());
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("key1"));
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("key2"));
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("key3"));
        ReplicatedHashMapTest.assertTrue(this.map1.containsKey("key4"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsKey("key1"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsKey("key2"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsKey("key3"));
        ReplicatedHashMapTest.assertTrue(this.map2.containsKey("key4"));
    }

    public void testClear() {
        ReplicatedHashMapTest.assertTrue(this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue(this.map2.isEmpty());
        this.map1.put("key", "value");
        ReplicatedHashMapTest.assertFalse(this.map1.isEmpty());
        ReplicatedHashMapTest.assertFalse(this.map2.isEmpty());
        this.map1.clear();
        ReplicatedHashMapTest.assertTrue(this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue(this.map2.isEmpty());
        this.map2.put("key", "value");
        ReplicatedHashMapTest.assertFalse(this.map1.isEmpty());
        ReplicatedHashMapTest.assertFalse(this.map2.isEmpty());
        this.map2.clear();
        ReplicatedHashMapTest.assertTrue(this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue(this.map2.isEmpty());
    }

    public void testKeySet() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map1.keySet());
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map2.keySet());
        this.map2.putAll(all2);
        all1.putAll(all2);
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map1.keySet());
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map2.keySet());
    }

    public void testValues() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        ReplicatedHashMapTest.assertTrue(this.map1.values().containsAll(all1.values()));
        ReplicatedHashMapTest.assertTrue(this.map2.values().containsAll(all1.values()));
        this.map2.putAll(all2);
        all1.putAll(all2);
        ReplicatedHashMapTest.assertTrue(this.map1.values().containsAll(all1.values()));
        ReplicatedHashMapTest.assertTrue(this.map2.values().containsAll(all1.values()));
    }
}

