/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class RingBuffer2<T> {
    private final ConcurrentLinkedQueue<T> queue;
    private final int capacity;
    private final AtomicInteger size = new AtomicInteger(0);

    public RingBuffer2(int capacity) {
        this.queue = new ConcurrentLinkedQueue();
        this.capacity = capacity;
    }

    public void add(T el) {
        if (el == null) {
            throw new IllegalArgumentException("null element");
        }
        int counter = 0;
        while (this.size.get() + 1 > this.capacity) {
            if (counter > 5) {
                LockSupport.parkNanos(10L);
                continue;
            }
            ++counter;
        }
        this.queue.add(el);
        this.size.incrementAndGet();
    }

    public T remove() {
        T el = this.queue.poll();
        if (el != null) {
            this.size.decrementAndGet();
        }
        return el;
    }

    public String dumpNonNullElements() {
        StringBuilder sb = new StringBuilder();
        for (T ref : this.queue) {
            if (ref == null) continue;
            sb.append(ref + " ");
        }
        return sb.toString();
    }

    public int size() {
        return this.queue.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size() + " elements");
        if (this.size() < 100) {
            sb.append(": ").append(this.dumpNonNullElements());
        }
        return sb.toString();
    }
}

