/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.NotificationTemplate;
import org.rhq.core.domain.configuration.Configuration;

@DiscriminatorColumn(name="NOTIFICATION_TYPE", discriminatorType=DiscriminatorType.STRING)
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQueries(value={@NamedQuery(name="AlertNotification.deleteById", query="DELETE FROM AlertNotification an WHERE an.id IN ( :ids )"), @NamedQuery(name="AlertNotification.deleteByResources", query="DELETE FROM AlertNotification an WHERE an.alertDefinition IN ( SELECT ad FROM AlertDefinition ad WHERE ad.resource.id IN ( :resourceIds ) )"), @NamedQuery(name="AlertNotification.deleteOrphaned", query="DELETE FROM AlertNotification an WHERE an.alertDefinition IS NULL AND an.notificationTemplate IS NULL")})
@SequenceGenerator(name="RHQ_ALERT_NOTIFICATION_ID_SEQ", sequenceName="RHQ_ALERT_NOTIFICATION_ID_SEQ")
@Table(name="RHQ_ALERT_NOTIFICATION")
public class AlertNotification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELETE_BY_ID = "AlertNotification.deleteById";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertNotification.deleteByResources";
    public static final String QUERY_DELETE_ORPHANED = "AlertNotification.deleteOrphaned";
    @Transient
    transient int alertDefinitionId;
    @Transient
    transient int alertNotificationId;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_NOTIFICATION_ID_SEQ")
    @Id
    private int id;
    @JoinColumn(name="ALERT_DEFINITION_ID")
    @ManyToOne
    private AlertDefinition alertDefinition;
    @JoinColumn(name="NOTIF_TEMPLATE_ID")
    @ManyToOne
    private NotificationTemplate notificationTemplate;
    @JoinColumn(name="ALERT_CONFIG_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration configuration;
    @Column(name="ALERT_SENDER_NAME")
    private String senderName;
    @Column(name="ALERT_ORDER")
    private int order;
    @Column(name="NAME")
    private String name;

    protected AlertNotification() {
    }

    public AlertNotification(AlertDefinition alertDefinition) {
        if (alertDefinition == null) {
            throw new IllegalArgumentException("alertDefinition must be non-null.");
        }
        this.alertDefinition = alertDefinition;
    }

    public AlertNotification(AlertDefinition alertDefinition, Configuration config) {
        if (alertDefinition == null) {
            throw new IllegalArgumentException("alertDefinition must be non-null.");
        }
        this.alertDefinition = alertDefinition;
        this.configuration = config.deepCopy();
    }

    public AlertNotification(int alertDefinitionId, int alertNotificationId) {
        this.alertDefinitionId = alertDefinitionId;
        this.alertNotificationId = alertNotificationId;
    }

    public AlertNotification(String name, String sender) {
        this.name = name;
        this.senderName = sender;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinition alertDefinition) {
        this.alertDefinition = alertDefinition;
    }

    public AlertNotification copy(boolean copyIds) {
        AlertNotification results = this.copy();
        if (copyIds) {
            results.id = this.id;
        }
        return results;
    }

    public AlertNotification copyWithAlertDefintion(AlertDefinition alertDefinition, boolean cloneConfiguration) {
        Configuration config = cloneConfiguration ? this.configuration.deepCopy(false) : this.configuration;
        AlertNotification notification = new AlertNotification(alertDefinition, config);
        notification.setName(this.name);
        notification.setSenderName(this.senderName);
        notification.setOrder(this.order);
        return notification;
    }

    protected AlertNotification copy() {
        return new AlertNotification(this.alertDefinition, this.configuration);
    }

    public void prepareForOrphanDelete() {
        this.alertDefinition = null;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotificationTemplate getNotificationTemplate() {
        return this.notificationTemplate;
    }

    public void setNotificationTemplate(NotificationTemplate notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public int getAlertDefinitionId() {
        return this.alertDefinitionId;
    }

    public int getAlertNotificationId() {
        return this.alertNotificationId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertNotification");
        sb.append("{alertDefinitionId=").append(this.alertDefinitionId);
        sb.append(", alertNotificationId=").append(this.alertNotificationId);
        sb.append(", id=").append(this.id);
        sb.append(", notificationTemplate=").append(this.notificationTemplate);
        sb.append(", senderName='").append(this.senderName).append('\'');
        sb.append(", order=").append(this.order);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

