/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.alert.notification.AlertNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamedQueries(value={@NamedQuery(name="NotificationTemplate.findByName", query="SELECT t FROM NotificationTemplate t WHERE t.name = :name"), @NamedQuery(name="NotificationTemplate.findAll", query="SELECT t FROM NotificationTemplate AS t")})
@Entity
@Table(name="RHQ_ALERT_NOTIF_TEMPL")
@SequenceGenerator(name="RHQ_ALERT_NOTIF_TEMPL_ID_SEQ", sequenceName="RHQ_ALERT_NOTIF_TEMPL_ID_SEQ")
public class NotificationTemplate
implements Serializable {
    public static final String FIND_BY_NAME = "NotificationTemplate.findByName";
    public static final String FIND_ALL = "NotificationTemplate.findAll";
    @Column(name="ID", nullable=false)
    @GeneratedValue(generator="RHQ_ALERT_NOTIF_TEMPL_ID_SEQ")
    @Id
    private int id;
    @Column(name="NAME")
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @OneToMany(mappedBy="notificationTemplate", cascade={CascadeType.ALL})
    List<AlertNotification> notifications = new ArrayList<AlertNotification>();

    protected NotificationTemplate() {
    }

    public NotificationTemplate(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AlertNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<AlertNotification> notifications) {
        this.notifications = notifications;
    }

    public List<AlertNotification> addNotification(AlertNotification notification) {
        this.notifications.add(notification);
        return this.notifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationTemplate that = (NotificationTemplate)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NotificationTemplate");
        sb.append("{id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

