/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="BundleDeployDefinition.findAll", query="SELECT bdd FROM BundleDeployDefinition bdd")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_DEPLOY_DEF_ID_SEQ")
@Table(name="RHQ_BUNDLE_DEPLOY_DEF")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleDeployDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "BundleDeployDefinition.findAll";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="CTIME")
    private Long ctime = System.currentTimeMillis();
    @Column(name="MTIME")
    private Long mtime = System.currentTimeMillis();
    @JoinColumn(name="CONFIG_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, optional=true)
    private Configuration configuration;
    @Column(name="ENFORCE_POLICY", nullable=false)
    private boolean enforcePolicy;
    @Column(name="ENFORCEMENT_INTERVAL", nullable=true)
    private int enforcementInterval;
    @JoinColumn(name="BUNDLE_VERSION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private BundleVersion bundleVersion;
    @JoinColumn(name="BUNDLE_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne(fetch=FetchType.LAZY)
    private Bundle bundle;
    @OneToMany(mappedBy="bundleDeployDefinition", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<BundleDeployment> deployments = new ArrayList<BundleDeployment>();

    public BundleDeployDefinition() {
    }

    public BundleDeployDefinition(BundleVersion bundleVersion, String name) {
        this.bundleVersion = bundleVersion;
        this.name = name;
        this.enforcePolicy = false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCtime() {
        return this.ctime;
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = Long.valueOf(System.currentTimeMillis());
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    public boolean isEnforcePolicy() {
        return this.enforcePolicy;
    }

    public void setEnforcePolicy(boolean enforcePolicy) {
        this.enforcePolicy = enforcePolicy;
    }

    public int getEnforcementInterval() {
        return this.enforcementInterval;
    }

    public void setEnforcementInterval(int enforcementInterval) {
        this.enforcementInterval = enforcementInterval;
    }

    public BundleVersion getBundleVersion() {
        return this.bundleVersion;
    }

    public void setBundleVersion(BundleVersion bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public List<BundleDeployment> getDeployments() {
        return this.deployments;
    }

    public void addDeployment(BundleDeployment bundleDeployment) {
        this.deployments.add(bundleDeployment);
        bundleDeployment.setBundleDeployDefinition(this);
    }

    public void setDeployments(List<BundleDeployment> deployments) {
        this.deployments = deployments;
    }

    public String toString() {
        return "BundleDeployDefinition[id=" + this.id + ", name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleVersion == null ? 0 : this.bundleVersion.hashCode());
        result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BundleDeployDefinition)) {
            return false;
        }
        BundleDeployDefinition other = (BundleDeployDefinition)obj;
        if (this.bundleVersion == null ? other.bundleVersion != null : !this.bundleVersion.equals(other.bundleVersion)) {
            return false;
        }
        if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

