/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageVersion;

@Entity
@NamedQueries(value={@NamedQuery(name="BundleFile.findAll", query="SELECT bf FROM BundleFile bf"), @NamedQuery(name="BundleFile.findByBundleVersionId", query="SELECT bf FROM BundleFile bf WHERE bf.bundleVersion.id = :id")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_FILE_ID_SEQ")
@Table(name="RHQ_BUNDLE_FILE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "BundleFile.findAll";
    public static final String QUERY_FIND_BY_BUNDLE_VERSION_ID = "BundleFile.findByBundleVersionId";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="BUNDLE_VERSION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private BundleVersion bundleVersion;
    @JoinColumn(name="PACKAGE_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne(fetch=FetchType.LAZY)
    private Package generalPackage;
    @JoinColumn(name="PACKAGE_VERSION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private PackageVersion packageVersion;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public BundleVersion getBundleVersion() {
        return this.bundleVersion;
    }

    public void setBundleVersion(BundleVersion bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public Package getPackage() {
        return this.generalPackage;
    }

    public void setPackage(Package pkg) {
        this.generalPackage = pkg;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(PackageVersion packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String toString() {
        return "BundleFile[id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleVersion == null ? 0 : this.bundleVersion.hashCode());
        result = 31 * result + (this.generalPackage == null ? 0 : this.generalPackage.hashCode());
        result = 31 * result + (this.packageVersion == null ? 0 : this.packageVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BundleFile)) {
            return false;
        }
        BundleFile other = (BundleFile)obj;
        if (this.bundleVersion == null ? other.bundleVersion != null : !this.bundleVersion.equals(other.bundleVersion)) {
            return false;
        }
        if (this.generalPackage == null ? other.generalPackage != null : !this.generalPackage.equals(other.generalPackage)) {
            return false;
        }
        return !(this.packageVersion == null ? other.packageVersion != null : !this.packageVersion.equals(other.packageVersion));
    }
}

