/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.cloud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.domain.resource.Agent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="Server")
@NamedQueries(value={@NamedQuery(name="Server.findAll", query="SELECT s FROM Server s"), @NamedQuery(name="Server.findAllComposites", query="SELECT NEW org.rhq.core.domain.cloud.composite.ServerWithAgentCountComposite     (        s,        (SELECT COUNT(a) FROM Agent a WHERE a.server = s)      )   FROM Server s"), @NamedQuery(name="Server.findByName", query="         SELECT s            FROM Server s LEFT JOIN FETCH s.affinityGroup           WHERE s.name = :name"), @NamedQuery(name="Server.findAllCloudMembers", query="SELECT s FROM Server s WHERE NOT s.operationMode = 'INSTALLED'"), @NamedQuery(name="Server.findAllNormalCloudMembers", query="SELECT s FROM Server s WHERE s.operationMode = 'NORMAL'"), @NamedQuery(name="Server.findByAffinityGroup", query="SELECT s   FROM Server s  WHERE s.affinityGroup.id = :affinityGroupId "), @NamedQuery(name="Server.findWithoutAffinityGroup", query="SELECT s   FROM Server s  WHERE s.affinityGroup IS NULL "), @NamedQuery(name="Server.deleteById", query="DELETE FROM Server s WHERE s.id = :serverId "), @NamedQuery(name="Server.updateSetStaleDown", query="UPDATE Server s    SET s.operationMode = :downMode  WHERE s.operationMode = :normalMode    AND s.mtime < :staleTime    AND ( s.name <> :thisServerName OR :thisServerName IS NULL ) "), @NamedQuery(name="Server.updateStatusByName", query=" UPDATE Server s     SET s.status = -1   WHERE s.status = 0     AND s.name = :identity ")})
@SequenceGenerator(name="id", sequenceName="RHQ_SERVER_ID_SEQ")
@Table(name="RHQ_SERVER")
public class Server
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "Server.findAll";
    public static final String QUERY_FIND_ALL_COMPOSITES = "Server.findAllComposites";
    public static final String QUERY_FIND_BY_NAME = "Server.findByName";
    public static final String QUERY_FIND_ALL_CLOUD_MEMBERS = "Server.findAllCloudMembers";
    public static final String QUERY_FIND_BY_AFFINITY_GROUP = "Server.findByAffinityGroup";
    public static final String QUERY_FIND_WITHOUT_AFFINITY_GROUP = "Server.findWithoutAffinityGroup";
    public static final String QUERY_DELETE_BY_ID = "Server.deleteById";
    public static final String QUERY_UPDATE_SET_STALE_DOWN = "Server.updateSetStaleDown";
    public static final String QUERY_FIND_ALL_NORMAL_CLOUD_MEMBERS = "Server.findAllNormalCloudMembers";
    public static final String QUERY_UPDATE_STATUS_BY_NAME = "Server.updateStatusByName";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="ADDRESS", nullable=false)
    private String address;
    @Column(name="PORT", nullable=false)
    private int port;
    @Column(name="SECURE_PORT", nullable=false)
    private int securePort;
    @Column(name="OPERATION_MODE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private OperationMode operationMode;
    @Column(name="COMPUTE_POWER", nullable=false)
    private int computePower;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @Column(name="MTIME", nullable=false)
    private long mtime;
    @JoinColumn(name="AFFINITY_GROUP_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private AffinityGroup affinityGroup;
    @OneToMany(mappedBy="server", fetch=FetchType.LAZY)
    private List<Agent> agents = new ArrayList<Agent>();
    @Column(name="STATUS", nullable=false)
    private int status;

    public Server() {
    }

    public Server(int serverId) {
        this.id = serverId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    public int getComputePower() {
        return this.computePower;
    }

    public void setComputePower(int computePower) {
        this.computePower = computePower;
    }

    public long getCtime() {
        return this.ctime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public AffinityGroup getAffinityGroup() {
        return this.affinityGroup;
    }

    public void setAffinityGroup(AffinityGroup affinityGroup) {
        this.affinityGroup = affinityGroup;
    }

    public OperationMode getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(OperationMode operationMode) {
        this.operationMode = operationMode;
    }

    public List<Agent> getAgents() {
        return this.agents;
    }

    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    public int getAgentCount() {
        return this.agents.size();
    }

    public FailoverListComposite.ServerEntry getServerEntry() {
        return new FailoverListComposite.ServerEntry(this.id, this.address, this.port, this.securePort);
    }

    public int getStatus() {
        return this.status;
    }

    public void clearStatus() {
        this.status = 0;
    }

    public void addStatus(Status newStatus) {
        this.status |= newStatus.mask;
    }

    public List<String> getStatusMessages() {
        return Status.getMessages(this.status);
    }

    public String toString() {
        return "Server[id=" + this.getId() + ",name=" + this.getName() + ",address=" + this.getAddress() + ",port=" + this.getPort() + ",securePort=" + this.getSecurePort() + "]";
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Server)) {
            return false;
        }
        Server other = (Server)obj;
        if (this.ctime != other.ctime) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RESOURCE_HIERARCHY_UPDATED(1, "The resource hierarchy has been updated"),
        ALERT_DEFINITION(2, "Some alert definition with a global condition category was updated");

        public final int mask;
        public final String message;

        private Status(int mask, String message) {
            this.mask = mask;
            this.message = message;
        }

        public static List<String> getMessages(int mask) {
            ArrayList<String> results = new ArrayList<String>();
            for (Status next : Status.values()) {
                if (next.mask != (next.mask & mask)) continue;
                results.add(next.message);
            }
            return results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationMode {
        DOWN("This server is down member of the HA server cloud"),
        INSTALLED("This server is newly installed but not yet fully operating"),
        MAINTENANCE("This server is a Maintenance Mode member of the HA server cloud"),
        NORMAL("This server is a Normal Member of the HA server cloud");

        public final String message;

        private OperationMode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

