/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DiscriminatorValue(value="map")
@Entity(name="PropertyDefinitionMap")
@XmlRootElement(name="PropertyDefinitionMap")
@XmlSeeAlso(value={PropertyDefinitionSimple.class, PropertyDefinitionList.class, PropertyDefinitionMap.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PropertyDefinitionMap
extends PropertyDefinition {
    private static final long serialVersionUID = 1L;
    @MapKey(name="name")
    @OneToMany(mappedBy="parentPropertyMapDefinition", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy
    private Map<String, PropertyDefinition> map;

    public PropertyDefinitionMap(@NotNull String name, String description, boolean required, PropertyDefinition ... properties) {
        super(name, description, required);
        if (properties != null) {
            for (PropertyDefinition property : properties) {
                this.put(property);
            }
        }
    }

    protected PropertyDefinitionMap() {
    }

    @NotNull
    public Map<String, PropertyDefinition> getPropertyDefinitions() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, PropertyDefinition>();
        }
        return this.map;
    }

    public void setPropertyDefinitions(@NotNull Map<String, PropertyDefinition> propertyDefinitions) {
        this.map = propertyDefinitions;
    }

    @NotNull
    public List<PropertyDefinition> getSummaryPropertyDefinitions() {
        ArrayList<PropertyDefinition> summaryDefinitions = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition propertyDefinition : this.getPropertyDefinitions().values()) {
            if (!propertyDefinition.isSummary()) continue;
            summaryDefinitions.add(propertyDefinition);
        }
        if (summaryDefinitions.isEmpty()) {
            summaryDefinitions.addAll(this.getPropertyDefinitions().values());
        }
        return summaryDefinitions;
    }

    public PropertyDefinitionSimple getPropertyDefinitionSimple(String name) {
        return (PropertyDefinitionSimple)this.get(name);
    }

    public PropertyDefinitionList getPropertyDefinitionList(String name) {
        return (PropertyDefinitionList)this.get(name);
    }

    public PropertyDefinitionMap getPropertyDefinitionMap(String name) {
        return (PropertyDefinitionMap)this.get(name);
    }

    public PropertyDefinition get(String name) {
        return this.getPropertyDefinitions().get(name);
    }

    public void put(PropertyDefinition propertyDefinition) {
        this.getPropertyDefinitions().put(propertyDefinition.getName(), propertyDefinition);
        propertyDefinition.setParentPropertyMapDefinition(this);
    }
}

