/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.PackageVersion;

@Entity
@NamedQueries(value={@NamedQuery(name="AdvisoryPackage.findPackagesByAdvId", query="SELECT ap FROM AdvisoryPackage AS ap WHERE ap.advisory.id = :advId"), @NamedQuery(name="AdvisoryPackage.deletePackagesByAdvId", query="DELETE AdvisoryPackage ap WHERE ap.advisory.id = :advId"), @NamedQuery(name="AdvisoryPackage.findAdvisoryPackage", query="SELECT ap FROM AdvisoryPackage AS ap WHERE ap.advisory.id = :advId AND ap.pkg.id = :pkgVerId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_ADVISORY_PACKAGE_ID_SEQ")
@Table(name="RHQ_ADVISORY_PACKAGE")
public class AdvisoryPackage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_PACKAGES_BY_ADV_ID = "AdvisoryPackage.findPackagesByAdvId";
    public static final String DELETE_PACKAGES_BY_ADV_ID = "AdvisoryPackage.deletePackagesByAdvId";
    public static final String FIND_ADVISORY_PACKAGE = "AdvisoryPackage.findAdvisoryPackage";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="ADVISORY_ID", referencedColumnName="ID", nullable=false)
    private Advisory advisory;
    @ManyToOne
    @JoinColumn(name="PACKAGE_VERSION_ID", referencedColumnName="ID", nullable=false)
    private PackageVersion pkg;
    @Column(name="LAST_MODIFIED", nullable=true)
    private long lastModifiedDate;

    protected AdvisoryPackage() {
    }

    public AdvisoryPackage(Advisory adv, PackageVersion pkg) {
        this.advisory = adv;
        this.pkg = pkg;
    }

    public Advisory getAdvisory() {
        return this.advisory;
    }

    public void setAdvisory(Advisory advisory) {
        this.advisory = advisory;
    }

    public PackageVersion getPkg() {
        return this.pkg;
    }

    public void setPkg(PackageVersion pkg) {
        this.pkg = pkg;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @PrePersist
    void onPersist() {
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AdvisoryPackage: ");
        str.append(", Advisory=[").append(this.advisory).append("]");
        str.append(", Package=[").append(this.pkg).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.advisory == null ? 0 : this.advisory.hashCode());
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AdvisoryPackage)) {
            return false;
        }
        AdvisoryPackage other = (AdvisoryPackage)obj;
        if (this.advisory == null ? this.advisory != null : !this.advisory.equals(other.advisory)) {
            return false;
        }
        return !(this.pkg == null ? this.pkg != null : !this.pkg.equals(other.pkg));
    }
}

