/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.Resource;

@Entity
@NamedQueries(value={@NamedQuery(name="InstalledPackage.findBySetOfIds", query="SELECT ip FROM InstalledPackage AS ip WHERE ip.id IN ( :packageIds )"), @NamedQuery(name="InstalledPackage.findBySetOfPackageVerIds", query="SELECT ip FROM InstalledPackage AS ip WHERE ip.packageVersion.id IN ( :packageIds )"), @NamedQuery(name="InstalledPackage.findByResourceId", query="SELECT ip FROM InstalledPackage AS ip WHERE ip.resource.id = :resourceId"), @NamedQuery(name="InstalledPackage.findByResourceIdAndPackageVersionId", query="SELECT ip FROM InstalledPackage AS ip WHERE ip.resource.id = :resourceId AND ip.packageVersion.id = :packageVersionId"), @NamedQuery(name="InstalledPackage.findByResourceAndPackage", query="SELECT ip FROM InstalledPackage AS ip WHERE ip.resource.id = :resourceId AND ip.packageVersion.generalPackage.id = :packageId  "), @NamedQuery(name="InstalledPackage.findByResourceAndPackageVer", query="SELECT ip FROM InstalledPackage AS ip WHERE ip.resource.id = :resourceId AND ip.packageVersion.id = :packageVersionId  "), @NamedQuery(name="InstalledPackage.findPackageListItemComposite", query="SELECT new org.rhq.core.domain.content.composite.PackageListItemComposite(ip.id, gp.name, pt.displayName, ip.packageVersion.version, ip.installationDate )  FROM InstalledPackage ip JOIN ip.resource res LEFT JOIN ip.packageVersion pv LEFT JOIN pv.generalPackage gp LEFT JOIN gp.packageType pt WHERE res.id = :resourceId   AND (:packageTypeFilterId = pt.id OR :packageTypeFilterId is null)   AND (:packageVersionFilter = ip.packageVersion.version OR :packageVersionFilter is null)  AND (UPPER(gp.name) LIKE :search OR :search is null) "), @NamedQuery(name="InstalledPackage.findPackageListTypes", query="SELECT DISTINCT new org.rhq.core.domain.common.composite.IntegerOptionItem(pt.id, pt.displayName)     FROM InstalledPackage ip JOIN ip.resource res LEFT JOIN ip.packageVersion pv LEFT JOIN pv.generalPackage gp LEFT JOIN gp.packageType pt    WHERE res.id = :resourceId ORDER BY pt.displayName"), @NamedQuery(name="InstalledPackage.findPackageListVersions", query="SELECT DISTINCT pv.version     FROM InstalledPackage ip JOIN ip.resource res LEFT JOIN ip.packageVersion pv    WHERE res.id = :resourceId ORDER BY pv.version"), @NamedQuery(name="InstalledPackage.findInstalledPackageHistory", query="SELECT ip FROM InstalledPackage ip JOIN ip.resource res LEFT JOIN ip.packageVersion pv LEFT JOIN pv.generalPackage gp LEFT JOIN gp.packageType pt WHERE res.id = :resourceId   AND gp.id = :generalPackageId"), @NamedQuery(name="InstalledPackage.deleteByResources", query="DELETE FROM InstalledPackage ip  WHERE ip.resource.id IN ( :resourceIds )")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_INSTALLED_PACKAGE_ID_SEQ")
@Table(name="RHQ_INSTALLED_PACKAGE")
public class InstalledPackage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_SET_OF_IDS = "InstalledPackage.findBySetOfIds";
    public static final String QUERY_FIND_BY_SET_OF_PACKAGE_VER_IDS = "InstalledPackage.findBySetOfPackageVerIds";
    public static final String QUERY_FIND_BY_RESOURCE_ID = "InstalledPackage.findByResourceId";
    public static final String QUERY_FIND_BY_RESOURCE_ID_AND_PKG_VER_ID = "InstalledPackage.findByResourceIdAndPackageVersionId";
    public static final String QUERY_FIND_BY_RESOURCE_AND_PACKAGE = "InstalledPackage.findByResourceAndPackage";
    public static final String QUERY_FIND_BY_RESOURCE_AND_PACKAGE_VER = "InstalledPackage.findByResourceAndPackageVer";
    public static final String QUERY_FIND_PACKAGE_LIST_ITEM_COMPOSITE = "InstalledPackage.findPackageListItemComposite";
    public static final String QUERY_FIND_PACKAGE_LIST_TYPES = "InstalledPackage.findPackageListTypes";
    public static final String QUERY_FIND_PACKAGE_LIST_VERSIONS = "InstalledPackage.findPackageListVersions";
    public static final String QUERY_FIND_INSTALLED_PACKAGE_HISTORY = "InstalledPackage.findInstalledPackageHistory";
    public static final String QUERY_DELETE_BY_RESOURCES = "InstalledPackage.deleteByResources";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Resource resource;
    @JoinColumn(name="PACKAGE_VERSION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private PackageVersion packageVersion;
    @Column(name="INSTALLATION_TIME", nullable=true)
    private Long installationDate;
    @JoinColumn(name="SUBJECT_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private Subject user;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(PackageVersion packageVersion) {
        this.packageVersion = packageVersion;
    }

    public Long getInstallationDate() {
        return this.installationDate;
    }

    public void setInstallationDate(Long installationDate) {
        this.installationDate = installationDate;
    }

    public Subject getUser() {
        return this.user;
    }

    public void setUser(Subject user) {
        this.user = user;
    }

    public String toString() {
        return "InstalledPackage[resource=" + this.resource.getName() + ",packageVersion=" + this.packageVersion.getDisplayName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InstalledPackage)) {
            return false;
        }
        InstalledPackage that = (InstalledPackage)o;
        if (this.packageVersion != null ? !this.packageVersion.equals(that.packageVersion) : that.packageVersion != null) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(that.resource) : that.resource != null);
    }

    public int hashCode() {
        int result = this.resource != null ? this.resource.hashCode() : 0;
        result = 31 * result + (this.packageVersion != null ? this.packageVersion.hashCode() : 0);
        return result;
    }
}

