/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoContentSourcePK;

@Entity
@IdClass(value=RepoContentSourcePK.class)
@NamedQueries(value={@NamedQuery(name="RepoContentSource.deleteByContentSourceId", query="DELETE RepoContentSource ccs WHERE ccs.contentSource.id = :contentSourceId"), @NamedQuery(name="RepoContentSource.deleteByRepoId", query="DELETE RepoContentSource ccs WHERE ccs.repo.id = :repoId")})
@Table(name="RHQ_REPO_CONTENT_SRC_MAP")
public class RepoContentSource
implements Serializable {
    public static final String DELETE_BY_CONTENT_SOURCE_ID = "RepoContentSource.deleteByContentSourceId";
    public static final String DELETE_BY_REPO_ID = "RepoContentSource.deleteByRepoId";
    private static final long serialVersionUID = 1L;
    @Id
    private Repo repo;
    @Id
    private ContentSource contentSource;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected RepoContentSource() {
    }

    public RepoContentSource(Repo repo, ContentSource contentSource) {
        this.repo = repo;
        this.contentSource = contentSource;
    }

    public RepoContentSourcePK getRepoContentSourcePK() {
        return new RepoContentSourcePK(this.repo, this.contentSource);
    }

    public void setRepoContentSourcePK(RepoContentSourcePK pk) {
        this.repo = pk.getRepo();
        this.contentSource = pk.getContentSource();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RepoContentSource: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", ch=[").append(this.repo).append("]");
        str.append(", cs=[").append(this.contentSource).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.contentSource == null ? 0 : this.contentSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoContentSource)) {
            return false;
        }
        RepoContentSource other = (RepoContentSource)obj;
        if (this.repo == null ? this.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.contentSource == null ? this.contentSource != null : !this.contentSource.equals(other.contentSource));
    }
}

