/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoPackageVersionPK;

@Entity
@IdClass(value=RepoPackageVersionPK.class)
@NamedQueries(value={@NamedQuery(name="RepoPackageVersion.deleteByRepoId", query="DELETE RepoPackageVersion cpv WHERE cpv.repo.id = :repoId"), @NamedQuery(name="RepoPackageVersion.deleteWhenNoProvider", query="DELETE RepoPackageVersion rpv WHERE rpv.repo.id = :repoId   AND (SELECT COUNT(pvcs.packageVersion.id)        FROM PackageVersionContentSource pvcs) = 0")})
@Table(name="RHQ_REPO_PKG_VERSION_MAP")
public class RepoPackageVersion
implements Serializable {
    public static final String DELETE_BY_REPO_ID = "RepoPackageVersion.deleteByRepoId";
    public static final String DELETE_WHEN_NO_PROVIDER = "RepoPackageVersion.deleteWhenNoProvider";
    private static final long serialVersionUID = 1L;
    @Id
    private Repo repo;
    @Id
    private PackageVersion packageVersion;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected RepoPackageVersion() {
    }

    public RepoPackageVersion(Repo repo, PackageVersion packageVersion) {
        this.repo = repo;
        this.packageVersion = packageVersion;
    }

    public RepoPackageVersionPK getRepoPackageVersionPK() {
        return new RepoPackageVersionPK(this.repo, this.packageVersion);
    }

    public void setRepoPackageVersionPK(RepoPackageVersionPK pk) {
        this.repo = pk.getRepo();
        this.packageVersion = pk.getPackageVersion();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RepoPV: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", ch=[").append(this.repo).append("]");
        str.append(", pv=[").append(this.packageVersion).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.packageVersion == null ? 0 : this.packageVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoPackageVersion)) {
            return false;
        }
        RepoPackageVersion other = (RepoPackageVersion)obj;
        if (this.repo == null ? this.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.packageVersion == null ? this.packageVersion != null : !this.packageVersion.equals(other.packageVersion));
    }
}

